import React from "react";
import { Button } from "../Buttons";
import { MdClose } from "react-icons/md";

interface DrawerProps {
  isOpen: boolean;
  children: React.ReactNode;
  onClose: () => void;
  closable: boolean;
  width?: string;
}

const Drawer = ({
  isOpen,
  children,
  onClose,
  width,
  closable,
}: DrawerProps) => {
  return (
    <div
      className={`fixed inset-0 z-30 transition-opacity duration-500 ease-in-out ${
        isOpen
          ? "visible bg-black/50 opacity-100 backdrop-blur-0"
          : "invisible opacity-0"
      }`}
      onClick={() => closable && onClose()}
    >
      <div
        style={{ width: width || 600 }}
        className={`drawer fixed right-0 top-0 z-40 h-full bg-whiteShade p-5 shadow-sm transition-all duration-500 ease-in-out ${isOpen ? "translate-x-0" : "translate-x-full"}`}
        onClick={(e) => e.stopPropagation()}
      >
        <Button
          onClick={onClose}
          variant="normal"
          className="absolute right-5 top-5 z-50"
        >
          <MdClose size={26} className="text-grey" />
        </Button>
        {isOpen && children}
      </div>
    </div>
  );
};

export default Drawer;
