"use client";

import { AppDispatch, RootState } from "@/redux/store";
import React, { useEffect, useRef, useState } from "react";
import { getJitsiJwt } from "@/services/jitsiToken.service";
// import toast from "react-hot-toast";
import { useDispatch, useSelector } from "react-redux";
import { Button } from "../Buttons";
import {
  MdArrowDownward,
  MdArrowUpward,
  MdCancel,
  MdDownload,
  MdOutlineCallEnd,
  MdOutlineMessage,
  MdOutlineMicNone,
  MdOutlineMicOff,
  MdOutlinePerson,
  MdOutlineScreenShare,
  MdOutlineStopScreenShare,
  MdOutlineVideocam,
  MdOutlineVideocamOff,
  MdPersonAddAlt,
} from "react-icons/md";
import InviteIcon from "@/assets/icons/invite_to_call.svg";
import ScreenRecordIcon from "@/assets/icons/screen_record_FILL0_wght500_GRAD0_opsz24.svg";
// import { setPopupChildren, togglePopup } from "@/redux/global/globalSlice";
import { IoInformationCircleOutline } from "react-icons/io5";
import { getInitials } from "@/utils/utilities";
import Image from "next/image";
import useScreenTools from "@/hooks/useScreenTools";
import useCall from "@/hooks/useCall";

const InsideCallPanel = () => {
  const localStreamRef = useRef<HTMLVideoElement>(null);

  const {
    // usersOnCall,
    endCall,
    // maximizeRemoteVideo,
    stopSharingScreen,
    shareScreen,
    state,
    toggleMic,
    toggleVideo,
    // mediaTracks,
    myVideoTrack,
    localStream,
  } = useCall({ localStreamRef: localStreamRef });
  const {
    onStartScreenRecording,
    handleStopRecording,
    downloadScreenRecording,
    recording,
    videoFile,
    isCaptured,
    mediaElementRef,
    removeFile,
  } = useScreenTools();

  const dispatch = useDispatch<AppDispatch>();
  const { activeUser } = useSelector((state: RootState) => state.user);
  const { currentMeetingId, callType } = useSelector((state: RootState) => state.call);

  const videoRef = useRef<HTMLVideoElement>(null);

  useEffect(() => {
    if (videoRef.current && localStream) {
      videoRef.current.srcObject = localStream;
    }
  }, [localStream]);

  const [isMin, setIsMin] = useState<boolean>(false);
  const handleContextMenu = (event: any) => {
    event.preventDefault();
  };
  const { audioMode, videoMode, screenMode } = state;

  // const callUrlLink = window.open(
  //   `https://meet.xolanibridge.com/${currentMeetingId}?user=${activeUser?.firstName}`,
  // );

  return (
    <>
      <div
        className={` ${!isMin ? "fixed left-0 top-0 z-50 h-full w-full bg-[#00000040]" : ""}`}
      >
        <div
          style={{ borderRadius: "16px 16px 0px 0px" }}
          className={`fixed ${
            isMin && "translate-y-[0px] transition-all"
          } bottom-0 left-0 z-[1000] flex h-auto w-full flex-col overflow-visible bg-[#FDFDFD] shadow-2xl transition-all`}
        >
          {/* Video wrapper */}

          <div
            style={{
              boxShadow:
                "rgba(0, 0, 0, 0.25) 0px 54px 55px, " +
                "rgba(0, 0, 0, 0.12) 0px -12px 30px, " +
                "rgba(0, 0, 0, 0.12) 0px 4px 6px, " +
                "rgba(0, 0, 0, 0.17) 0px 12px 13px, " +
                "rgba(0, 0, 0, 0.09) 0px -3px 5px",
            }}
            className={`relative flex items-center justify-center bg-white p-6 ${isMin ? "visible" : "hidden"} transition-all`}
          >
            <p className="font-norma l mb-0 text-[#646C6D]">
              Call currently in progress; tap the green button to open the call
              panel.
            </p>

            {isMin && (
              <div className="absolute bottom-3 right-10 z-50 flex animate-bounce flex-col items-center justify-center">
                {/* <Tooltip title={"Show call panel"}> */}
                <Button
                  variant="normal"
                  onClick={() => setIsMin(!isMin)}
                  className=""
                >
                  {<MdArrowUpward size={25} />}
                </Button>
                {/* </Tooltip> */}
              </div>
            )}
          </div>

          <div className={`${isMin ? "hidden" : "visible"} transition-all`}>
            <div className="relative flex flex-row gap-2 p-5">
              {/* minimize arrow */}
              {!isMin && (
                <div className="absolute right-6 top-4 flex animate-pulse flex-col items-center justify-center">
                  {/* <Tooltip title={"Hide call panel"}> */}
                  <Button
                    variant="normal"
                    onClick={() => setIsMin(!isMin)}
                    className="z-[99998]"
                  >
                    <MdArrowDownward size={25} />
                  </Button>
                  {/* </Tooltip> */}
                </div>
              )}
              {/* <div className="relative flex h-[150px] w-[200px] items-center justify-center overflow-hidden rounded-2xl border border-gray-200 bg-[#011E21] text-gray-500 sm:h-[200px] sm:w-[250px]">
                <p className="absolute bottom-2 left-3 z-10 w-1/2 truncate text-ellipsis text-white">
                  {`${activeUser?.firstName || ""} ${activeUser?.lastName || ""} (You)`}
                </p>

                <video
                  muted={true}
                  ref={localStreamRef}
                  autoPlay
                  playsInline
                  style={{
                    objectFit: "cover",
                    height: "100%",
                    width: "100%",
                    transform: "scalex(-1)",
                  }}
                  className={`${myVideoTrack.current?.enabled ? "visible" : "hidden"}`}
                />
                <div
                  className={`${
                    !myVideoTrack.current?.enabled
                      ? "visible z-[100]"
                      : "hidden"
                  } flex h-[70px] w-[70px] items-center justify-center rounded-full bg-[#0796A7] text-2xl text-[#ffffff]`}
                >
                  {getInitials(
                    `${activeUser?.firstName || "Ola"} ${activeUser?.lastName || "Joshua"}`,
                  )}
                </div>
                {/* )} */}
              {/* </div> */}
              {isCaptured && (
                <div
                  className="absolute bottom-0 left-1/3 right-1/3 w-64 rounded-[14px] border border-primary bg-[#27272b] p-5"
                  onContextMenu={handleContextMenu}
                >
                  {videoFile && (
                    <video
                      width="100%"
                      height="100%"
                      className="border border-primary"
                      ref={mediaElementRef}
                      controls
                    >
                      <source
                        src={URL.createObjectURL(videoFile)}
                        type="video/mp4"
                      />
                    </video>
                  )}

                  <div className="relative flex w-full justify-between pt-2">
                    {videoFile && (
                      <Button
                        variant="primary"
                        className="px-4"
                        onClick={() => {
                          downloadScreenRecording();
                        }}
                      >
                        <MdDownload />
                      </Button>
                    )}
                    {videoFile && (
                      <Button
                        className="border-1 rounded-full border-solid border-red-500 bg-red-500 px-4 text-white hover:bg-red-500"
                        variant="secondary"
                        onClick={() => {
                          removeFile();
                        }}
                      >
                        <MdCancel />
                      </Button>
                    )}
                  </div>
                </div>
              )}
              {/*  {usersOnCall?.length
                ? usersOnCall?.map((user, index) => (
                    <div
                      className="remote-stream-container border border-gray-200 bg-white text-gray-500"
                      id={`remote_user_${user?.id}`}
                    >
                      {
                        // callType == 'voice' ? (
                        //   <div className="flex flex-col justify-center align-middle mt-8">
                        //     <IoPersonCircle size={80} className="self-center" />
                        //     <Text className="text-gray-400 text-md text-center" ellipsis={true} title="User">
                        //       Voice calling...
                        //     </Text>
                        //     <Text className="text-gray-400 text-sm text-center">
                        //       {user?.firstName + ' ' + user?.lastName}
                        //     </Text>
                        //     <video
                        //       id={`remote_user_${user?.id}_video`}
                        //       ref={user?.stream}
                        //       autoPlay
                        //       playsInline
                        //       style={{
                        //         display: 'none',
                        //       }}
                        //     />
                        //   </div>
                        // ) :
                        user?.stream ? (
                          <div className="relative">
                            <Text
                              ellipsis={true}
                              className="absolute left-2 top-2 w-1/2 text-ellipsis text-white"
                            >
                              {user?.firstName + " " + user?.lastName}
                            </Text>
                            {user?.isMuted ? (
                              <Button
                                onClick={() => null}
                                className="absolute right-12 top-2 z-10 flex h-8 w-8 flex-col items-center justify-center rounded-full border border-red-500 bg-transparent text-red-500 hover:bg-transparent"
                              >
                                <MdMicOff size={20} className="text-red-500" />
                              </Button>
                            ) : (
                              <Button
                                onClick={() => null}
                                className="absolute right-12 top-2 z-10 flex h-8 w-8 flex-col items-center justify-center rounded-full border border-green-500 bg-transparent text-green-500 hover:bg-transparent"
                              >
                                <MdOutlineMic
                                  size={20}
                                  className="text-green-500"
                                />
                              </Button>
                            )}
                            <Tooltip title="Full screen" placement="top">
                              <Button
                                onClick={() => maximizeRemoteVideo(user?.id)}
                                className="absolute right-2 top-2 z-10 flex h-8 w-8 flex-col items-center justify-center rounded-md border border-white bg-transparent text-white hover:bg-transparent"
                              >
                                <MdFullscreen
                                  size={20}
                                  className="hover:scale-110"
                                />
                              </Button>
                            </Tooltip>

                            <video
                              id={`remote_user_${user?.id}_video`}
                              ref={user?.stream}
                              autoPlay
                              playsInline
                              style={{
                                objectFit: "cover",
                                height: "100%",
                                width: "100%",
                              }}
                            />
                          </div>
                        ) : (
                          <div className="flex flex-col justify-center align-middle">
                            <IoPersonCircle size={80} className="self-center" />
                            <Text
                              className="text-md text-center text-gray-400"
                              ellipsis={true}
                              title={user?.firstName + " " + user?.lastName}
                            >
                              Video calling...
                            </Text>
                            <Text className="text-center text-sm text-gray-400">
                              {user?.firstName + " " + user?.lastName}
                            </Text>
                          </div>
                        )
                      }
                    </div>
                  ))
                : null} */}

              <div className="flex flex-col items-center w-full">
                {/* Outer container for video/start call and message */}
                <div className="flex flex-col items-center w-full gap-2">
                  {/* Inner container: video panel and start call button side by side */}
                  <div className="flex flex-row items-center justify-start w-full gap-4">
                    {/* Video panel */}
                    <div className="relative h-[150px] w-[200px] flex items-center justify-center overflow-hidden rounded-2xl border border-gray-200 bg-[#011E21] text-gray-500 sm:h-[200px] sm:w-[250px]">
                      <p className="absolute bottom-2 left-3 z-10 w-1/2 truncate text-ellipsis text-white">
                        {`${activeUser?.firstName || ""} ${activeUser?.lastName || ""} (You)`}
                      </p>
                      <video
                        muted={true}
                        ref={localStreamRef}
                        autoPlay
                        playsInline
                        style={{
                          objectFit: "cover",
                          height: "100%",
                          width: "100%",
                          transform: "scalex(-1)",
                          display: myVideoTrack.current?.enabled ? 'block' : 'none',
                        }}
                      />
                      {/* Only show initials if video is off */}
                      { !myVideoTrack.current?.enabled && (
                        <div className="absolute inset-0 flex h-full w-full items-center justify-center">
                          <div className="flex h-[70px] w-[70px] items-center justify-center rounded-full bg-[#0796A7] text-2xl text-[#ffffff]">
                            {getInitials(
                              `${activeUser?.firstName || "Ola"} ${activeUser?.lastName || "Joshua"}`,
                            )}
                          </div>
                        </div>
                      )}
                    </div>
                    {/* Start call button */}
                    <div className="flex flex-col items-center">
                      <div className="flex h-[150px] w-[200px] cursor-pointer justify-center rounded-2xl border border-greyStroke bg-white sm:h-[200px] sm:w-[250px]"
                        onClick={async () => {
                          if (!activeUser || !currentMeetingId) return;
                          try {
                            const jwt = await getJitsiJwt({
                              firstName: activeUser.firstName,
                              lastName: activeUser.lastName,
                              email: activeUser.email,
                              meetingId: currentMeetingId,
                              userId: activeUser.id,
                              avatar: activeUser.profileImage || "",
                            });
                            // Set video muted if callType is 'voice', otherwise unmuted for 'video'
                            const videoMuted = callType === 'voice' ? 'true' : 'false';
                            const meetingUrl = `https://meet.xolanibridge.com/${currentMeetingId}?jwt=${jwt}#config.startWithVideoMuted=${videoMuted}`;
                            window.open(meetingUrl, "_blank");
                            window.location.reload();
                          } catch {
                            // Optionally show a toast error here
                          }
                        }}>
                        <div className="flex flex-col self-center">
                          {/* <Tooltip title={"Invite to call"}> */}
                          <Image
                            src={InviteIcon}
                            alt="invite icon"
                            className="size-20 self-center text-primary"
                          />
                          {/* </Tooltip> */}
                          <p className="truncate text-center text-sm text-grey">
                            Start call
                          </p>
                        </div>
                      </div>
                    </div>
                  </div>
                  {/* Separate container for the message */}
                  <div className="w-full">
                    <p className="w-full rounded bg-red-50 py-2 text-sm font-medium text-red-500 text-center mt-2">
                      You have to start and join the call before guests can join.
                    </p>
                  </div>
                </div>
              </div>
            </div>

            <div
              style={{
                boxShadow: " rgba(0, 0, 0, 0.35) 0px 5px 15px",
              }}
              className="relative flex w-full items-center justify-between gap-2 overflow-auto border-t border-gray-200 px-4 py-4"
            >
              <div className="">
                {/* <Tooltip
                    color="#86CED1"
                    title={
                      <p className="mb-0 flex items-center align-middle">
                        <strong>Code:&nbsp;</strong> {currentMeetingId}
                        <span
                          className="cursor-pointer pl-2 hover:scale-105"
                          onClick={() => copyText("Meeting code", callUrlLink)}
                        >
                          <IoCopy size={18} />
                        </span>
                      </p>
                    }
                  > */}
                <Button
                  iconPrefix={<IoInformationCircleOutline size={18} />}
                  variant="primary"
                  className="h-10 whitespace-nowrap px-3"
                >
                  <span>Call Details</span>
                </Button>
                {/* </Tooltip> */}
              </div>
              <div className="flex items-center justify-center gap-2">
                <div className="flex flex-col items-center justify-center">
                  {/* <Tooltip
                    color="#86CED1"
                    title={audioMode ? "Mute" : "Unmute"}
                  > */}
                  <Button
                    variant="primary"
                    className={`h-10 w-10 rounded-full px-0 ${
                      audioMode
                        ? "bg-primaryLight"
                        : "border-callInactiveBg bg-callInactiveBg hover:bg-callInactiveBg"
                    } `}
                    onClick={toggleMic}
                  >
                    {audioMode ? (
                      <MdOutlineMicNone size={22} />
                    ) : (
                      <MdOutlineMicOff size={22} />
                    )}
                  </Button>
                  {/* </Tooltip> */}
                </div>

                {/* {callType == 'video' && ( */}
                <div className="flex flex-col items-center justify-center">
                  {/* <Tooltip
                    color="#86CED1"
                    title={videoMode ? "Turn off Camera" : "Turn on Camera"}
                  > */}
                  <Button
                    variant="primary"
                    className={`h-10 w-10 rounded-full px-0 ${
                      videoMode
                        ? "bg-primaryLight"
                        : "border-callInactiveBg bg-callInactiveBg hover:bg-callInactiveBg"
                    } `}
                    onClick={toggleVideo}
                  >
                    {videoMode ? (
                      <MdOutlineVideocam size={20} />
                    ) : (
                      <MdOutlineVideocamOff size={20} />
                    )}
                  </Button>
                  {/* </Tooltip> */}
                </div>
                {
                  // callType == 'video' ? (
                  screenMode ? (
                    <div className="flex flex-col items-center justify-center">
                      {/* <Tooltip color="#86CED1" title={"Stop Sharing"}> */}
                      <Button
                        variant="primary"
                        className="border-callInactiveBg bg-callInactiveBg hover:bg-callInactiveBg h-10 w-10 rounded-full px-0"
                        onClick={stopSharingScreen}
                      >
                        <MdOutlineStopScreenShare size={20} />
                      </Button>
                      {/* </Tooltip> */}
                    </div>
                  ) : (
                    <div className="flex flex-col items-center justify-center">
                      {/* <Tooltip color="#86CED1" title={"Share screen"}> */}
                      <Button
                        variant="primary"
                        className="h-10 w-10 rounded-full px-0"
                        onClick={shareScreen}
                      >
                        <MdOutlineScreenShare size={20} />
                      </Button>
                      {/* </Tooltip> */}
                    </div>
                  )
                  // ) : null
                }

                {!recording ? (
                  <div className="relative flex flex-col items-center justify-center">
                    {/* <Tooltip color="#86CED1" title={"Record Screen"}> */}
                    <Button
                      variant="primary"
                      onClick={onStartScreenRecording}
                      className="flex h-10 w-10 rounded-full px-0"
                    >
                      <Image
                        src={ScreenRecordIcon}
                        alt="screen-record"
                        className="h-full w-full text-white"
                      />
                    </Button>
                    {/* </Tooltip> */}
                  </div>
                ) : (
                  <div className="relative flex flex-col items-center justify-center">
                    {/* <Tooltip color="#86CED1" title={"Stop Recording"}> */}
                    <Button
                      variant="primary"
                      onClick={handleStopRecording}
                      className="border-callInactiveBg bg-callInactiveBg hover:bg-callInactiveBg flex h-10 w-10 rounded-full px-0"
                    >
                      <Image
                        src={ScreenRecordIcon}
                        alt="screen-record"
                        className="h-full w-full"
                      />
                    </Button>
                    {/* </Tooltip> */}
                  </div>
                )}

                <div className="flex flex-col items-center justify-center">
                  {/* <Tooltip color="#86CED1" title={"End call"}> */}
                  <Button
                    variant="primary"
                    onClick={endCall}
                    className="flex h-10 w-16 flex-col items-center justify-center rounded-full bg-red-500 align-middle text-white hover:scale-105 hover:border-red-500 hover:bg-red-500 sm:h-10 sm:w-10"
                  >
                    <MdOutlineCallEnd color="white" size={20} />
                  </Button>
                  {/* </Tooltip> */}
                </div>
              </div>
              <div className="flex items-center justify-center gap-2">
                <div className="relative flex flex-col items-center justify-center">
                  {/* <Tooltip color="#86CED1" title={"Participants"}> */}
                  {/* <Badge
                      count={Number(usersOnCall?.length) + 1}
                      overflowCount={10}
                    > */}
                  <Button
                    variant="normal"
                    className="bg-callGreyBg hover:bg-callGreyBg h-10 w-10 rounded-full px-0"
                  >
                    <MdOutlinePerson size={19} className="text-white" />
                  </Button>
                  {/* </Badge>
                  </Tooltip> */}
                </div>

                <div className="relative flex flex-col items-center justify-center">
                  {/* <Tooltip color="#86CED1" title={"Add contact to call"}> */}
                  <Button
                    variant="normal"
                    className="bg-callGreyBg hover:bg-callGreyBg h-10 w-10 rounded-full px-0"
                    //   onClick={() => {
                    //     dispatch(togglePopup(true));
                    //     dispatch(
                    //       setPopupChildren(
                    //         <InviteTocall
                    //           usersOnCall={usersOnCall}
                    //           endCall={endCall}
                    //         />,
                    //       ),
                    //     );
                    //   }}
                  >
                    <MdPersonAddAlt size={19} className="text-white" />
                  </Button>
                  {/* </Tooltip> */}
                </div>
                <div className="relative flex flex-col items-center justify-center">
                  {/* <Tooltip color="#86CED1" title={"Chats"}>
                    <Badge count={newCallMessages} overflowCount={10}> */}
                  <Button
                    variant="normal"
                    className="bg-callGreyBg hover:bg-callGreyBg h-10 w-10 rounded-full px-0"
                    // onClick={() => {
                    //   dispatch(togglePopup(true));
                    //   dispatch(
                    //     setPopupChildren(
                    //       <MessageDialogue
                    //         setNewCallMessages={setNewCallMessages}
                    //       />,
                    //     ),
                    //   );
                    //   setNewCallMessages(0);
                    // }}
                  >
                    <MdOutlineMessage size={19} className="text-white" />
                  </Button>
                  {/* </Badge>
                  </Tooltip> */}
                </div>
              </div>

              {/* )} */}
            </div>
          </div>
        </div>
      </div>
    </>
  );
};

export default InsideCallPanel;
