"use client";

import { Button } from "@/components/Buttons";
import PageHeader from "@/components/common/PageHeader";
import { ActionDropdown } from "@/components/Dropdowns/ActionDropdown";
import AppTabs from "@/components/Tab/Tab";
import { ColumnConfig, generateColumns } from "@/components/Table/column";
import { DataTable } from "@/components/Table/DataTable";
import { AppDispatch, RootState } from "@/redux/store";
import { useRouter } from "next/navigation";
import React, { useCallback, useEffect, useState } from "react";
import { BsThreeDotsVertical } from "react-icons/bs";
import {
  MdOutlineCloudQueue,
  MdOutlineCloudUpload,
  MdRemoveRedEye,
  MdUpdate,
} from "react-icons/md";
import { useDispatch, useSelector } from "react-redux";
import useViewStudies from "./hooks/useViewStudies";
import { setSlideDetail } from "@/redux/data/dataSlice";
import moment from "moment";
import { Study } from "@/interfaces";
import { setPopupChildren, togglePopup } from "@/redux/global/globalSlice";

const Page = () => {
  const router = useRouter();
  const reduxDispatch = useDispatch<AppDispatch>();

  const { getSlides, loadingUploaded, handleSearch, search } = useViewStudies();

  const { slides } = useSelector((state: RootState) => state.data);
  const { activeUser } = useSelector((state: RootState) => state.user);

  useEffect(() => {
    getSlides(search.uploaded);
  }, [activeUser?.pathologist?.id]);

  const onUpdateSlide = (slide: Study) => {
    reduxDispatch(
      setPopupChildren({
        key: "firstPopup",
        componentKey: "manageUpdateSlidePersonal",
        props: {
          slide: slide,
          isDetail: false,
        },
      }),
    );
    reduxDispatch(togglePopup({ key: "firstPopup", isOpen: true }));
  };

  const studiesColumn: ColumnConfig<Study>[] = [
    {
      key: "patientName",
      header: "Patient Name",
    },
    {
      key: "modality",
      header: "Modality",
    },
    {
      key: "uploadProgress",
      header: "Uploaded",
    },
    {
      key: "createdAt",
      header: "Upload Date",
      cell: ({ row }) => {
        return (
          <div>{moment(row.original.createdAt).format("DD MMM YYYY")}</div>
        );
      },
    },
    {
      key: "status",
      header: "Status",
      cell: ({ row }) => {
        switch (row.original.status) {
          case "not_assigned":
            return (
              <div className="capitalize text-accentOrange">
                {row.original.status.replace("_", " ")}
              </div>
            );
          case "assigned":
            return (
              <div className="capitalize text-green-600">
                {row.original.status.replace("_", " ")}
              </div>
            );
          case "attended":
            return (
              <div className="capitalize text-primary">
                {row.original.status.replace("_", " ")}
              </div>
            );

          default:
            return (
              <div className="capitalize">
                {row.original.status.replace("_", " ")}
              </div>
            );
        }
      },
    },
    {
      key: "action",
      header: <p className="text-center">Action</p>,
      cell: ({ row }) => {
        return (
          <ActionDropdown
            theme="primary"
            align="end"
            className={{
              content: "w-fit bg-greyStroke",
              item: "hover:bg-white",
            }}
            trigger={
              <div
                className="flex justify-center"
                onClick={(e) => e.stopPropagation()}
              >
                <BsThreeDotsVertical />
              </div>
            }
            options={[
              {
                label: <div>View Study</div>,
                onClick: (e) => {
                  e?.stopPropagation();
                  router.push(`/personal/view-studies/${row.original.id}`);
                },
                icon: <MdRemoveRedEye />,
              },
              {
                label: <div>Update Slide</div>,
                onClick: (e) => {
                  e?.stopPropagation();
                  onUpdateSlide(row.original);
                },
                icon: <MdUpdate />,
              },
              // {
              //   label: <div>View Report</div>,
              //   onClick: () => {
              //     console.log("Studies");
              //   },
              //   icon: <MdRemoveRedEye />,
              // },
              // {
              //   label: <div>Share to Mail/Whatsapp</div>,
              //   onClick: () => {
              //     sendToWhatsApp();
              //   },
              //   icon: <MdOutlineShare />,
              // },
              // {
              //   label: <div>Delete Study</div>,
              //   onClick: () => {
              //     confirmDeleteStudy(row.original.id);
              //   },
              //   icon: <MdOutlineDelete />,
              // },
            ]}
          />
        );
      },
    },
  ];

  const columns = generateColumns(studiesColumn, {
    select: true,
    serialNumber: true,
  });

  const [filteredData, setFilteredData] = useState<Study[]>(slides);

  useEffect(() => {
    setFilteredData(slides);
  }, [slides]);

  const handleChange = useCallback((e: React.ChangeEvent<HTMLInputElement>) => {
    handleSearch(e, "uploaded");
  }, []);

  // const confirmDeleteStudy = (studyId: string | number) => {
  //   reduxDispatch(
  //     setPopupChildren({
  //       key: "firstPopup",
  //       componentKey: "prompt",
  //       props: {
  //         title: "Are you sure you want to delete the selected study?",
  //         bodyText:
  //           "By clicking 'Yes,' you confirm that you want to completely remove the selected study from your database.",
  //         buttonText: "Yes",
  //         onCloseKey: "firstPopup",
  //       },
  //     }),
  //   );
  //   reduxDispatch(togglePopup({ key: "firstPopup", isOpen: true }));
  // };

  // const sendToWhatsApp = () => {
  //   reduxDispatch(
  //     setPopupChildren({
  //       key: "firstPopup",
  //       componentKey: "manageSendToWhatsApp",
  //     }),
  //   );
  //   reduxDispatch(togglePopup({ key: "firstPopup", isOpen: true }));
  // };

  return (
    <div className="flex flex-col gap-4 px-2 py-6 md:px-8">
      <Button
        onClick={() => router.push("/personal/upload-studies")}
        iconPrefix={<MdOutlineCloudUpload size={20} />}
        variant="gradient"
        className="text-md ml-auto p-6"
      >
        Upload Studies
      </Button>
      <PageHeader
        title="My Studies"
        body="Easily find all your medical studies in one place! Access all the studies assigned to you and the ones you've uploaded."
      />

      <div className="">
        <AppTabs
          data={[
            // {
            //   trigger: "Assigned Studies",
            //   children: (
            //     <DataTable
            //       theme={"primary"}
            //       data={filteredData}
            //       columns={columns}
            //       stickLeft={[2]}
            //       search={{ ...search, handleChange }}
            //     />
            //   ),
            //   value: "1",
            //   count: 0,
            //   icon: MdOutlineAssignmentInd,
            // },
            {
              trigger: "Uploaded Studies",
              children: (
                <DataTable
                  theme={"primary"}
                  data={filteredData}
                  columns={columns}
                  stickLeft={[2]}
                  search={{ ...search.uploaded, handleChange }}
                  Loader={{
                    isLoading: loadingUploaded,
                    loaderText: "Loading Slides...",
                  }}
                  onRowClick={(data) => {
                    reduxDispatch(setSlideDetail({}));
                    router.push(`/personal/view-studies/${data?.id}`);
                  }}
                />
              ),
              value: "2",
              count: filteredData?.length || 0,
              icon: MdOutlineCloudQueue,
            },
          ]}
        />
      </div>
    </div>
  );
};

export default Page;
