import { setSlides } from "@/redux/data/dataSlice";
import { AppDispatch, RootState } from "@/redux/store";
import slideService from "@/services/slide.service";
import { useState } from "react";
import toast from "react-hot-toast";
import { useDispatch, useSelector } from "react-redux";

const useUploaded = () => {
  const [loadingUploaded, setLoading] = useState<boolean>(true);

  const reduxDispatch = useDispatch<AppDispatch>();

  const { activeUser } = useSelector((state: RootState) => state.user);

  const getSlides = async (search: {
    searchValue: string;
    fields: string[];
  }) => {
    if (activeUser?.pathologist?.id) {
      setLoading(true);
      slideService
        .getPathologistSlides({
          pathologistId: activeUser?.pathologist?.id,
          ...(search && {
            search: search.searchValue || "",
            searchFields: search.fields,
          }),
        })
        .then((res) => {
          reduxDispatch(setSlides(res.data as any[]));
        })
        .catch((error) => {
          console.log(error);
          toast.error(error?.message || error?.errors);
          setLoading(false);
        })
        .finally(() => setLoading(false));
    }
  };

  const getSlideDetail = async (pathologistId: number, slideId: string) => {
    try {
      const slideDetails = await slideService.getPathologistSlideDetail({
        pathologistId,
        slideId,
      });
      return slideDetails.slideImage;
    } catch (error) {
      console.error("Error fetching slide details:", error);
      return null;
    }
  };

  return {
    getSlides,
    loadingUploaded,
    getSlideDetail,
  };
};

export default useUploaded;
