"use client";

import React, { useState } from "react";
import { Button } from "@/components/Buttons";
import { PhoneInput, TextInput } from "@/components/Inputs";
import { Form, Formik } from "formik";
import { useSelector } from "react-redux";
import { RootState } from "@/redux/store";
import Loading from "@/components/Loading/Loading";
import { PERSONAL_USER_PROFILE_SCHEMA } from "@/utils/validationSchema/personal.schema";

interface FormValuesUser {
  firstName: string;
  lastName: string;
  phone: string;
  email: string;
}
const Page = () => {
  const { activeUser } = useSelector((state: RootState) => state.user);

  const [isLoading, setIsLoading] = useState<boolean>(false);
  const [loadingPage, setLoadingPage] = useState<boolean>(false);

  const initialValuesUser: FormValuesUser = {
    firstName: activeUser?.firstName || "",
    lastName: activeUser?.lastName || "",
    phone: `${activeUser?.phoneCode || "+234"}${activeUser?.phoneNumber || ""}`,
    email: activeUser?.email || "",
  };

  console.log(activeUser);

  if (loadingPage)
    return (
      <div className="relative h-full max-w-[600px] rounded-[8px] border border-greyStroke bg-whiteShade p-10">
        <Loading
          className={{
            loader: "!w-[40px]",
            loaderText: "text-lg text-grey",
          }}
          loaderText="Loading Profile..."
        />
      </div>
    );

  return (
    <div className="max-w-[600px] rounded-[8px] border border-greyStroke bg-whiteShade p-10">
      <Formik
        initialValues={initialValuesUser}
        validationSchema={PERSONAL_USER_PROFILE_SCHEMA}
        onSubmit={(values) => console.log(values)}
      >
        {() => (
          <Form className="flex flex-col gap-3">
            <TextInput
              name="firstName"
              type="text"
              label="First Name"
              placeholder="John"
              disabled={isLoading}
            />
            <TextInput
              name="lastName"
              type="text"
              label="Last Name"
              placeholder="Doe"
              disabled={isLoading}
            />

            <PhoneInput name="phone" label="Phone No." />

            <TextInput
              name="email"
              type="email"
              label="Email"
              placeholder="Enter your email"
              disabled={true}
            />

            <div className="mt-10 flex justify-end">
              <Button
                disabled={true}
                type="submit"
                variant="primary"
                loading={isLoading}
              >
                Update
              </Button>
            </div>
          </Form>
        )}
      </Formik>
    </div>
  );
};

export default Page;
