"use client";

import { getInitials } from "@/utils/utilities";
import React from "react";
import {
  MdOutlineEdit,
  MdOutlinePerson,
  MdOutlineVpnKey,
} from "react-icons/md";
import SettingItem from "./SettingItem";
import { RootState } from "@/redux/store";
import { useSelector } from "react-redux";
import { usePathname } from "next/navigation";

const SettingMenu = () => {
  const pathname = usePathname();

  const { activeUser } = useSelector((state: RootState) => state.user);

  const menuPath = pathname.split("/")[3];

  return (
    <div>
      <div className="flex flex-col items-center justify-center">
        <div className="flex size-[110px] items-center justify-center overflow-hidden rounded-full bg-primary object-cover text-5xl text-whiteShade shadow-lg">
          {getInitials(`${activeUser?.firstName} ${activeUser?.lastName}`)}
        </div>
        {/* <div className="mt-2 flex items-center gap-2 text-greySecondary">
          <span>Upload Logo</span>
          <MdOutlineEdit />
        </div> */}
      </div>
      <div className="mt-5 rounded-[8px] border border-greyStroke bg-whiteShade">
        <div className="border-b border-greyStroke px-10 py-8">
          <p className="text-2xl font-semibold text-grey">{`${activeUser?.firstName} ${activeUser?.lastName}`}</p>
        </div>
        <nav>
          <ul className="space-y-2 px-6 py-8">
            <SettingItem
              label="Profile"
              to="/personal/settings/profile"
              icon={<MdOutlinePerson size={20} />}
              isActive={menuPath === "profile"}
            />
            <SettingItem
              label="Password"
              to="/personal/settings/password"
              icon={<MdOutlineVpnKey size={20} />}
              isActive={menuPath === "password"}
            />
          </ul>
        </nav>
      </div>
    </div>
  );
};

export default SettingMenu;
