import Link from "next/link";
import React from "react";

type Props = {
  icon?: React.ReactNode;
  label: string;
  to: string;
  isActive?: boolean;
  onClick?: () => void;
};

const SettingItem = ({ onClick, to, icon, label, isActive }: Props) => {
  return (
    <li
      onClick={onClick}
      className={`w-fit rounded-bl-[8px] rounded-tl-[8px] ${isActive ? "" : ""} `}
    >
      <Link
        href={to}
        className={`flex cursor-pointer items-center gap-[10px] px-4 py-1 ${isActive ? "text-primaryMain" : "text-greySecondary"} transition-colors duration-200 ease-in-out hover:text-primaryLight`}
      >
        <span>{icon}</span>
        <span
          className={`whitespace-nowrap text-[16px] font-medium transition-colors duration-200 ease-in-out`}
        >
          {label}
        </span>
      </Link>
    </li>
  );
};

export default SettingItem;
