"use client";

import React, { useEffect, useState } from "react";
import Navbar from "@/components/Navbar/Navbar";
import PersonalSideBar from "@/components/SideBar/PersonalSideBar";
import { SidebarInset, SidebarProvider } from "@/components/ui/sidebar";
import { AppDispatch, RootState } from "@/redux/store";
import { setActiveRole, setActiveUser } from "@/redux/user/userSlice";
import {
  getSessionActiveRole,
  getToken,
  getUserData,
} from "@/utils/sessions/session.utils";
import { useRouter } from "next/navigation";
import { useDispatch, useSelector } from "react-redux";
import Smartlook from "smartlook-client";
import InsideCallPanel from "@/components/CallPanel/InsideCallPanel";
import PageSkeleton from "@/components/Loading/PageSkeleton";

export default function Layout({ children }: { children: React.ReactNode }) {
  const reduxDispatch = useDispatch<AppDispatch>();
  const router = useRouter();
  const [layoutLoading, setLayoutLoading] = useState<boolean>(true);
  const { onCall } = useSelector((state: RootState) => state.call);

  useEffect(() => {
    const initializeState = async () => {
      try {
        const storedUser = getUserData();
        const storedToken = getToken();
        const storedRole = getSessionActiveRole();

        if (!storedToken) {
          router.push("/auth/login");
          return;
        }

        if (!storedUser) {
          router.push("/auth/login");
          return;
        }

        reduxDispatch(setActiveUser(storedUser));

        if (storedRole) {
          reduxDispatch(setActiveRole(storedRole));
        }

        if (!storedRole) {
          router.push("/auth/account-select");
          return;
        }

        // Initialize Smartlook after user data is loaded
        Smartlook.identify("user", {
          email: storedUser?.email || "",
        });
      } catch (error) {
        console.log(error);
      } finally {
        setLayoutLoading(false);
      }
    };
    initializeState();
  }, []);

  return (
    <SidebarProvider defaultOpen={true} className="h-screen max-w-[2560px]">
      <PersonalSideBar />
      <SidebarInset className="overflow-hidden bg-greyLineLight">
        {layoutLoading ? (
          <PageSkeleton />
        ) : (
          <>
            <Navbar />
            <div className="flex-1 overflow-auto">{children}</div>
          </>
        )}
      </SidebarInset>
      {onCall && <InsideCallPanel />}
    </SidebarProvider>
  );
}
