import { setDashboard } from "@/redux/data/dataSlice";
import { AppDispatch, RootState } from "@/redux/store";
import pathologistService from "@/services/pathologist.service";
import { useState } from "react";
import { toast } from "react-hot-toast";
import { useDispatch, useSelector } from "react-redux";

const useDashboard = () => {
  const [isLoading, setIsLoading] = useState<boolean>(true);
  const { activeUser } = useSelector((state: RootState) => state.user);

  const reduxDispatch = useDispatch<AppDispatch>();
  const { dashboard } = useSelector((state: RootState) => state.data);

  const generateUserName = () => {
    return `${activeUser?.firstName || ""} ${activeUser?.lastName || ""}`;
  };

  const getDashboardData = () => {
    if (!activeUser?.pathologist?.id) return;

    if (!dashboard.distribution.length) {
      setIsLoading(true);
    } else setIsLoading(false);

    Promise.all([
      pathologistService.getPathologistDashboard({
        pathologistId: activeUser?.pathologist?.id,
      }),
      pathologistService.getPathologistStatistics({
        pathologistId: activeUser?.pathologist?.id,
      }),
      pathologistService.getPathologistDistribution({
        pathologistId: activeUser?.pathologist?.id,
      }),
    ])
      .then(([dashboard, statistics, distribution]) => {
        reduxDispatch(
          setDashboard({
            distribution: distribution?.data as any[],
            statistic: statistics?.data,
            dash: dashboard?.data,
          }),
        );
      })
      .catch((error) => {
        console.error(error);
        toast.error(error?.message || error?.errors);
      })
      .finally(() => {
        setIsLoading(false);
      });
  };

  return {
    generateUserName,
    isLoading,
    getDashboardData,
  };
};

export default useDashboard;
