import React from "react";

const StudyCount = ({
  icon,
  title,
  count,
}: {
  icon: React.ReactNode;
  title: string;
  count: number;
}) => {
  return (
    <div className="mb-2 flex items-center justify-between gap-4 text-[15px] font-semibold text-primary">
      <h3 className="m-0 flex items-center gap-2 text-primary">
        {icon} {title}
      </h3>
      <p className="m-0">{count}</p>
    </div>
  );
};

export default StudyCount;
