import React from "react";

interface Props {
  link: {
    icon: React.ReactNode;
    label: string;
    click: () => void;
  };
}

const Links = ({ link: { click, icon, label } }: Props) => {
  return (
    <div
      className={`flex cursor-pointer items-center gap-2 rounded-3xl border border-greyStroke bg-lightGreenLightest px-4 py-2 font-medium text-greySecondary shadow-sm transition-all duration-300 ease-in-out hover:scale-95 hover:bg-lightGreenLight`}
      onClick={click}
    >
      {icon}
      {label}
    </div>
  );
};

export default Links;
