import React from "react";
import cardBackground from "@/assets/icons/card-bg.svg";
import Image from "next/image";
import CountUp from "react-countup";

interface Props {
  card: {
    label: string;
    value: string | number;
    icon: React.ElementType;
  };
}

const DashCard = ({ card: { label, value, icon: Icon } }: Props) => {
  return (
    <div className="relative flex min-h-[137px] gap-4 overflow-hidden rounded-xl border border-greyStroke p-6">
      <Image
        className="absolute inset-0 top-0 z-0"
        alt="background"
        src={cardBackground}
      />
      <div className="z-10 flex flex-col">
        <span className="text-blackMain2 text-lg font-medium">{label}</span>
        <h4 className="text-blackMain2 text-[28px] font-semibold">
          {" "}
          <CountUp start={0} end={Number(value)} delay={0.5} />
        </h4>
      </div>
      <div className="absolute right-[-35px] top-[-55px] size-[135px] rounded-full bg-[#B3E0E550] shadow">
        <Icon
          className="text-primaary absolute bottom-[25px] left-[43px]"
          size={38}
          color="#068999"
        />
      </div>
    </div>
  );
};

export default DashCard;
