import type { Metadata } from "next";
import "./globals.css";
import { Toaster } from "react-hot-toast";
import ReduxLayout from "@/components/Layouts/ReduxLayout";
import PopupContainer from "@/components/Popup/PopupContainer";
import DrawerContainer from "@/components/Drawer/DrawerContainer";
import { SkeletonTheme } from "react-loading-skeleton";
import "react-loading-skeleton/dist/skeleton.css";
import Script from "next/script";

export const metadata: Metadata = {
  title: "Xolani Bridge",
  icons: {
    icon: "favicon.svg",
  },
  description:
    "A tele-pathology platform to bridge th gap in the medical space",
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="en">
      <body id="app-layout">
        <Script
          id="smartlook-init"
          strategy="afterInteractive" // Load after page becomes interactive
          dangerouslySetInnerHTML={{
            __html: `
              window.smartlook || (function(d) {
                var o = smartlook = function() { o.api.push(arguments) }, 
                h = d.getElementsByTagName('head')[0];
                var c = d.createElement('script'); 
                o.api = new Array(); 
                c.async = true; 
                c.type = 'text/javascript';
                c.charset = 'utf-8';
                c.src = 'https://web-sdk.smartlook.com/recorder.js';
                h.appendChild(c);
              })(document);
              smartlook('init', '${process.env.NEXT_PUBLIC_SMARTLOOK_KEY}', { region: 'eu' });
            `,
          }}
        />
        <ReduxLayout>
          <SkeletonTheme baseColor="#e5e5e5" highlightColor="#fefefe">
            {children}

            <PopupContainer />
            <DrawerContainer />
          </SkeletonTheme>
        </ReduxLayout>

        <Toaster
          position="top-right"
          reverseOrder={false}
          gutter={8}
          containerClassName=""
          containerStyle={{}}
          toastOptions={{
            // Define default options
            className: "",
            duration: 5000,
            removeDelay: 1000,
            style: {
              background: "#ffffff",
              color: "#363636",
              boxShadow: "2px 2px #2fa9b2",
            },
          }}
        />
      </body>
    </html>
  );
}
