"use client";

import { Button } from "@/components/Buttons";
import PageHeader from "@/components/common/PageHeader";
import AppTabs from "@/components/Tab/Tab";
import { RootState } from "@/redux/store";
import { useRouter } from "next/navigation";
import React, { useEffect, useMemo } from "react";
import {
  MdOutlineCloudQueue,
  MdOutlineCloudUpload,
  MdOutlineFolderShared,
} from "react-icons/md";
import { useSelector } from "react-redux";
import useViewStudies from "./hooks/useViewStudies";
import Uploaded from "./Uploaded";
import Shared from "./Shared";
import { IconType } from "react-icons/lib";

const Page = () => {
  const router = useRouter();

  const {
    getSlides,
    loadingUploaded,
    search,
    handleSearch,
    getSharedSlides,
    loadingShared,
  } = useViewStudies();

  const { slides, sharedSlides } = useSelector(
    (state: RootState) => state.data,
  );
  const { activeInstitution, activeUser } = useSelector(
    (state: RootState) => state.user,
  );

  useEffect(() => {
    getSlides(search.uploaded);
    getSharedSlides(search.shared);
  }, [activeInstitution?.id]);

  const isPathologist = useMemo(() => {
    return !!activeUser?.pathologist;
  }, [activeUser?.pathologist]);

  return (
    <div className="flex flex-col gap-4 px-2 py-6 md:px-8">
      <Button
        onClick={() => router.push("/institution/upload-studies")}
        iconPrefix={<MdOutlineCloudUpload size={20} />}
        variant="gradient"
        className="text-md ml-auto p-6"
      >
        Upload Studies
      </Button>
      <PageHeader
        title="My Studies"
        body="Easily find all your medical studies in one place! Access all the studies assigned to you and the ones you've uploaded."
      />

      <div className="">
        <AppTabs
          data={
            [
              {
                trigger: "Uploaded Studies",
                children: (
                  <Uploaded
                    isLoading={loadingUploaded}
                    handleSearch={handleSearch}
                    search={search.uploaded}
                  />
                ),
                value: "1",
                count: slides?.length || 0,
                icon: MdOutlineCloudQueue,
              },
              isPathologist
                ? {
                    trigger: "Shared Studies",
                    children: (
                      <Shared
                        isLoading={loadingShared}
                        handleSearch={handleSearch}
                        search={search.shared}
                      />
                    ),
                    value: "2",
                    count: sharedSlides?.length || 0,
                    icon: MdOutlineFolderShared,
                  }
                : null,
            ].filter(Boolean) as {
              trigger: React.ReactNode;
              value: string;
              count?: number;
              children: React.ReactNode;
              icon?: IconType;
            }[]
          }
        />
      </div>
    </div>
  );
};

export default Page;
