"use client";
import { ActionDropdown } from "@/components/Dropdowns/ActionDropdown";
import { ColumnConfig, generateColumns } from "@/components/Table/column";
import { DataTable } from "@/components/Table/DataTable";
import { setSlideDetail } from "@/redux/data/dataSlice";
// import { setPopupChildren, togglePopup } from "@/redux/global/globalSlice";
import { AppDispatch, RootState } from "@/redux/store";
import moment from "moment";
import { useRouter } from "next/navigation";
import React, { useCallback, useEffect, useState } from "react";
import { BsThreeDotsVertical } from "react-icons/bs";
import {
  // MdOutlineDelete,
  // MdOutlineShare,
  MdRemoveRedEye,
  MdUpdate,
} from "react-icons/md";
import { BiSolidReport } from "react-icons/bi";
import { useDispatch, useSelector } from "react-redux";
import { downloadReport } from "./components/ViewReport";
import { getReportFromLocalStorage } from "./[studyId]/(components)/Report/hooks/useReportStorage";
import useUploaded from "./hooks/useUploaded";
import { setPopupChildren, togglePopup } from "@/redux/global/globalSlice";
import { Study } from "@/interfaces";

interface SearchState {
  uploaded: {
    placeholder: string;
    searchValue: string;
    fields: string[];
  };
}

const Uploaded = ({
  isLoading,
  handleSearch,
  search,
}: {
  isLoading: boolean;
  handleSearch: (
    e: React.ChangeEvent<HTMLInputElement>,
    type: keyof SearchState,
  ) => void;
  search: {
    placeholder: string;
    searchValue: string;
    fields: string[];
  };
}) => {
  const router = useRouter();
  const reduxDispatch = useDispatch<AppDispatch>();

  const { slides } = useSelector((state: RootState) => state.data);
  const { activeUser, activeInstitution } = useSelector(
    (state: RootState) => state.user,
  );

  const { getSlideDetail } = useUploaded();

  const handleDownloadReport = async (slideId: string) => {
    if (!activeInstitution || !activeUser) return;
    const body = getReportFromLocalStorage(slideId);
    const slideDetail = await getSlideDetail(activeInstitution.id, slideId);

    downloadReport({
      report: body,
      slideDetail,
      activeInstitution,
      activeUser,
    });
  };

  const onUpdateSlide = (slide: Study) => {
    reduxDispatch(
      setPopupChildren({
        key: "firstPopup",
        componentKey: "manageUpdateSlide",
        props: {
          slide: slide,
          isDetail: false,
        },
      }),
    );
    reduxDispatch(togglePopup({ key: "firstPopup", isOpen: true }));
  };

  const studiesColumn: ColumnConfig<Study>[] = [
    {
      key: "patientName",
      header: "Patient Name",
    },
    {
      key: "modality",
      header: "Modality",
    },
    {
      key: "uploadProgress",
      header: "Uploaded",
    },
    {
      key: "createdAt",
      header: "Upload Date",
      cell: ({ row }) => {
        return (
          <div>{moment(row.original.createdAt).format("DD MMM YYYY")}</div>
        );
      },
    },
    {
      key: "status",
      header: "Status",
      cell: ({ row }) => {
        switch (row.original.status) {
          case "not_assigned":
            return (
              <div className="capitalize text-accentOrange">
                {row.original.status.replace("_", " ")}
              </div>
            );
          case "assigned":
            return (
              <div className="capitalize text-green-600">
                {row.original.status.replace("_", " ")}
              </div>
            );
          case "attended":
            return (
              <div className="capitalize text-primary">
                {row.original.status.replace("_", " ")}
              </div>
            );

          default:
            return (
              <div className="capitalize">
                {row.original.status.replace("_", " ")}
              </div>
            );
        }
      },
    },

    {
      key: "action",
      header: <p className="text-center">Action</p>,
      cell: ({ row }) => {
        return (
          <ActionDropdown
            theme="primary"
            align="end"
            className={{
              content: "w-fit bg-greyStroke",
              item: "hover:bg-white",
            }}
            trigger={
              <div className="flex justify-center">
                <BsThreeDotsVertical />
              </div>
            }
            options={[
              {
                label: <div>View Study</div>,
                onClick: () => {
                  reduxDispatch(setSlideDetail({}));
                  router.push(`/institution/view-studies/${row.original.id}`);
                },
                icon: <MdRemoveRedEye />,
              },
              // ...(row.original.status === "attended"
              //   ? [
              //       {
              //         label: <div>Generate Report</div>,
              //         onClick: () => handleDownloadReport(row.original.id),
              //         icon: <BiSolidReport />,
              //       },
              //     ]
              //   : []),
              {
                label: <div>Update Slide</div>,
                onClick: () => onUpdateSlide(row.original),
                icon: <MdUpdate />,
              },

              // {
              //   label: <div>Share to Mail/Whatsapp</div>,
              //   onClick: () => {
              //     sendToWhatsApp();
              //   },
              //   icon: <MdOutlineShare />,
              // },
              // {
              //   label: <div>Delete Study</div>,
              //   onClick: () => {
              //     confirmDeleteStudy(row.original.id);
              //   },
              //   icon: <MdOutlineDelete />,
              // },
            ].filter(Boolean)}
          />
        );
      },
    },
  ];

  const columns = generateColumns(studiesColumn, {
    select: true,
    serialNumber: true,
  });

  const [filteredData, setFilteredData] = useState<Study[]>(slides);

  useEffect(() => {
    setFilteredData(slides);
  }, [slides]);

  const handleChange = useCallback((e: React.ChangeEvent<HTMLInputElement>) => {
    handleSearch(e, "uploaded");
  }, []);

  // const confirmDeleteStudy = (studyId: string | number) => {
  //   reduxDispatch(
  //     setPopupChildren({
  //       key: "firstPopup",
  //       componentKey: "prompt",
  //       props: {
  //         title: "Are you sure you want to delete the selected study?",
  //         bodyText:
  //           "By clicking 'Yes,' you confirm that you want to completely remove the selected study from your database.",
  //         buttonText: "Yes",
  //         onCloseKey: "firstPopup",
  //       },
  //     }),
  //   );
  //   reduxDispatch(togglePopup({ key: "firstPopup", isOpen: true }));
  // };

  // const sendToWhatsApp = () => {
  //   reduxDispatch(
  //     setPopupChildren({
  //       key: "firstPopup",
  //       componentKey: "manageSendToWhatsApp",
  //     }),
  //   );
  //   reduxDispatch(togglePopup({ key: "firstPopup", isOpen: true }));
  // };

  return (
    <React.Fragment>
      <DataTable
        theme="primary"
        data={filteredData}
        columns={columns}
        stickLeft={[2]}
        search={{ ...search, handleChange }}
        Loader={{
          isLoading: isLoading,
          loaderText: "Loading Slides...",
        }}
        onRowClick={(data) => {
          reduxDispatch(setSlideDetail({}));
          router.push(`/institution/view-studies/${data?.id}`);
        }}
      />
    </React.Fragment>
  );
};

export default Uploaded;
