"use client";

import React from "react";
import { Button } from "@/components/Buttons";
import PageHeader from "@/components/common/PageHeader";
import { SelectInput, TextInput } from "@/components/Inputs";
import { Card, CardContent, CardHeader } from "@/components/ui/card";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";
import { MdOutlineCloudUpload } from "react-icons/md";
import toast from "react-hot-toast";
import { Form, Formik } from "formik";
// import useUploadStudy from "./hook/useUploadStudy";
import Loading from "@/components/Loading/Loading";
import { useCaMicroscopeUpload } from "./hooks/useCaMicroscopeUpload";
import * as Progress from "@radix-ui/react-progress";
import { UPLOAD_SLIDE_SCHEMA } from "@/utils/validationSchema/institution.schema";
import { IoMdCloseCircle } from "react-icons/io";
import { FaUsersViewfinder } from "react-icons/fa6";
import { modalityTypesArray } from "../constants";
import { useDispatch } from "react-redux";
import { AppDispatch } from "@/redux/store";
import { setPopupChildren, togglePopup } from "@/redux/global/globalSlice";

const Page = () => {
  const reduxDispatch = useDispatch<AppDispatch>();

  const {
    isExtracting,
    uploaded,
    file,
    handleFileUpload,
    handleSubmitStudy,
    isUploading,
    uploadProgress,
    formValues,
    setFormValues,
    onRemoveFile,
    isLoadingReal,
    setIsLoadingReal,
  } = useCaMicroscopeUpload();

  // console.log(isUploading, ">>>>>", uploadProgress);

  const startRealTime = () => {
    setIsLoadingReal(true);

    setTimeout(() => {
      reduxDispatch(
        setPopupChildren({
          key: "firstPopup",
          componentKey: "realTImeView",
        }),
      );
      reduxDispatch(togglePopup({ key: "firstPopup", isOpen: true }));

      setIsLoadingReal(false);
    }, 2000);
  };

  return (
    <div className="max-w-[1440px] space-y-10 p-6 px-2 md:px-8">
      <PageHeader
        title="Upload Study"
        body="  Simply upload your scans or images, choose your preferred pathologist,
          make your payment, and relax – your reports will be ready in just 1 to
          2 hours!"
      />

      <div className="rounded-lg border border-greyStroke bg-whiteShade px-2 py-10 md:px-6">
        <Tabs defaultValue="single" className="w-full">
          <TabsList className="mb-6 w-full justify-normal">
            <TabsTrigger
              value="single"
              className="group flex h-[74px] w-1/3 flex-col items-center justify-start gap-2 rounded-none border-b-2 data-[state=active]:border-b-[#243436] data-[state=active]:shadow-none max-sm:px-2 sm:flex-row"
            >
              <div className="flex size-[30px] items-center justify-center rounded-full border-2 border-dashed border-greyLine text-lg font-medium text-greySecondary ease-in-out group-data-[state=active]:text-[#243436] max-sm:text-sm sm:size-[50px]">
                1
              </div>
              <span className="truncate text-[14px] font-medium text-greySecondary ease-in-out group-data-[state=active]:text-[#243436] max-md:flex-1 max-sm:w-full sm:text-[16px]">
                Upload Single DCM or ZIP file
              </span>
            </TabsTrigger>
            <TabsTrigger
              value="multiple"
              className="group flex h-[74px] w-1/3 flex-col items-center justify-start gap-2 rounded-none border-b-2 data-[state=active]:border-b-[#243436] data-[state=active]:shadow-none max-sm:px-2 sm:flex-row"
            >
              <div className="flex size-[30px] items-center justify-center rounded-full border-2 border-dashed border-greyLine text-lg font-medium text-greySecondary ease-in-out group-data-[state=active]:text-[#243436] max-sm:text-sm sm:size-[50px]">
                2
              </div>
              <span className="truncate text-[14px] font-medium text-greySecondary ease-in-out group-data-[state=active]:text-[#243436] max-md:flex-1 max-sm:w-full sm:text-[16px]">
                Upload Multiple DCM or ZIP file
              </span>
            </TabsTrigger>
            <TabsTrigger
              value="real"
              className="group flex h-[74px] w-1/3 flex-col items-center justify-start gap-2 rounded-none border-b-2 data-[state=active]:border-b-[#243436] data-[state=active]:shadow-none max-sm:px-2 sm:flex-row"
            >
              <div className="flex size-[30px] items-center justify-center rounded-full border-2 border-dashed border-greyLine text-lg font-medium text-greySecondary ease-in-out group-data-[state=active]:text-[#243436] max-sm:text-sm sm:size-[50px]">
                3
              </div>
              <span className="truncate text-[14px] font-medium text-greySecondary ease-in-out group-data-[state=active]:text-[#243436] max-md:flex-1 max-sm:w-full sm:text-[16px]">
                View in Real Time
              </span>
            </TabsTrigger>
          </TabsList>

          <TabsContent className="relative space-y-8" value={"single"}>
            <Card className="rounded-none border-2 border-dashed border-greyLine bg-greyFill">
              {uploaded && (
                <span
                  className="absolute right-2 top-2 cursor-pointer"
                  onClick={() => onRemoveFile()}
                >
                  <IoMdCloseCircle size={20} />
                </span>
              )}
              <CardHeader className="flex flex-col items-center justify-center space-y-3 p-12 text-center max-md:p-5">
                <MdOutlineCloudUpload
                  className="text-greySecondary"
                  size={60}
                />

                <input
                  type="file"
                  id="input-field"
                  hidden
                  accept=".dcm, .ndpi, .tiff, .svs, .jpg, .png, .jpeg"
                  disabled={isExtracting}
                  onChange={({ target }) => {
                    if (target.files?.length) {
                      handleFileUpload(target.files[0]);
                    }
                  }}
                />
                {uploaded ? (
                  <p className="text-[16px] text-grey">
                    <span className="font-medium">
                      You have selected{" "}
                      {file && (
                        <span className="font-semibold">{file?.name}</span>
                      )}
                      , and it's ready to be uploaded.
                    </span>
                  </p>
                ) : (
                  <>
                    <p className="font-medium text-greySecondary">
                      Drag and drop files here
                    </p>
                    <p className="text-sm text-gray-500">or</p>
                    <Button
                      variant="gray"
                      onClick={() => {
                        const inputElement =
                          document?.querySelector<HTMLInputElement>(
                            "#input-field",
                          );
                        inputElement?.click();
                      }}
                      className="bg-greyDisabled text-blackMain"
                    >
                      Browse Files
                    </Button>
                    <CardContent className="p-0">
                      <p className="mb-0 text-sm font-medium text-grey">
                        {" "}
                        Drop a medical image here or browse one to start.
                      </p>

                      <p className="text-sm font-medium text-red-500">
                        Please note that each upload should be related to the
                        same patient
                      </p>
                    </CardContent>
                  </>
                )}
              </CardHeader>
            </Card>
            {uploaded && (
              <>
                <div className="mt-8">
                  <h4 className="text-xl font-medium text-grey">
                    Additional Details
                  </h4>
                  <span className="text-greySecondary">
                    Please provide additional details for this slide.
                  </span>
                  <Card className="mt-5 rounded-sm">
                    <CardContent className="p-8">
                      <Formik
                        initialValues={formValues}
                        validationSchema={UPLOAD_SLIDE_SCHEMA}
                        onSubmit={(values) => {
                          setFormValues(values);
                          setTimeout(() => {
                            handleSubmitStudy();
                          }, 500);
                        }}
                      >
                        {() => (
                          <>
                            <Form
                              id="uploadSlideForm"
                              className="grid grid-cols-1 gap-8 md:grid-cols-2"
                            >
                              <div className="">
                                <p className="text-sm text-grey">Slide Name</p>
                                <TextInput
                                  type="text"
                                  name="slideName"
                                  className=""
                                  disabled={isUploading}
                                  placeholder="Enter slide name"
                                />
                              </div>
                              <div className="">
                                <p className="text-sm text-grey">
                                  Patient Name
                                </p>
                                <TextInput
                                  type="text"
                                  name="patientName"
                                  disabled={isUploading}
                                  className=""
                                  placeholder="Enter patient name"
                                />
                              </div>
                              <div className="">
                                <p className="text-sm text-grey">
                                  Comments (Optional)
                                </p>
                                <TextInput
                                  type="textarea"
                                  name="comment"
                                  className=""
                                  disabled={isUploading}
                                  rows={4}
                                  placeholder="Enter additional info"
                                />
                              </div>
                              <div className="">
                                <p className="text-sm text-grey">Modality</p>
                                <SelectInput
                                  name="modality"
                                  options={modalityTypesArray}
                                  disabled={isUploading}
                                  type="primary"
                                  placeholder=""
                                  className={{
                                    content: "w-full",
                                    trigger:
                                      "h-[40px] w-full rounded-[4px] border-greyLine text-blackMain outline-none",
                                  }}
                                />
                              </div>
                            </Form>
                            <Button
                              loading={isUploading}
                              className="ml-auto mt-10"
                              variant="primary"
                              type="submit"
                              form="uploadSlideForm"
                            >
                              Upload Study
                            </Button>
                          </>
                        )}
                      </Formik>
                    </CardContent>
                  </Card>
                </div>
              </>
            )}

            {(isExtracting || isUploading) && (
              <>
                <Loading className={{ loader: "!w-[40px]" }} />
                {isUploading && (
                  <div className="absolute inset-0 z-40 flex h-full w-full items-center justify-center gap-2">
                    <Progress.Root
                      value={uploadProgress}
                      className="relative h-[25px] w-[200px] translate-y-14 items-center overflow-hidden rounded-[20px] bg-greyLine"
                    >
                      <Progress.Indicator
                        style={{
                          transform: `translateX(-${100 - uploadProgress}%)`,
                        }}
                        className="h-full w-full !bg-primaryMain"
                      />
                    </Progress.Root>
                    <span className="translate-y-14 font-medium text-blackMain">
                      {`${uploadProgress}%`}
                    </span>
                  </div>
                )}
              </>
            )}
          </TabsContent>
          <TabsContent value={"multiple"}>
            <Card className="rounded-none border-2 border-dashed border-greyLine bg-greyFill">
              <CardHeader className="flex flex-col items-center justify-center space-y-3 p-12 text-center max-md:p-5">
                <MdOutlineCloudUpload
                  className="text-greySecondary"
                  size={60}
                />
                <p className="font-medium text-greySecondary">
                  Drag and drop files here
                </p>
                <p className="text-sm text-gray-500">or</p>
                <Button
                  variant="gray"
                  className="bg-greyDisabled text-blackMain"
                  onClick={() => toast("Coming Soon!!!")}
                >
                  Browse Files
                </Button>
                <CardContent className="p-0">
                  <p className="text-sm font-medium text-red-500">
                    Please note that each upload should be related to the same
                    patient
                  </p>
                </CardContent>
              </CardHeader>
            </Card>
          </TabsContent>
          <TabsContent value={"real"}>
            <Card className="rounded-none border-2 border-dashed border-greyLine bg-greyFill">
              <CardHeader className="flex flex-col items-center justify-center space-y-3 p-12 text-center max-md:p-5">
                <FaUsersViewfinder className="text-greySecondary" size={60} />
                <p className="font-medium text-greySecondary">
                  View the slides in real time with collegues
                </p>
                <p className="text-sm text-gray-500">
                  A link would be gnerated to copy and share
                </p>
                <Button
                  variant="gray"
                  className="bg-greyDisabled text-blackMain"
                  onClick={() => startRealTime()}
                  loading={isLoadingReal}
                >
                  Start
                </Button>
                <CardContent className="p-0">
                  <p className="text-sm font-medium text-red-500">
                    Please note that you can copy or share the link on whatsapp
                    or email to your colleagues.
                  </p>
                </CardContent>
              </CardHeader>
            </Card>
          </TabsContent>
        </Tabs>
      </div>
    </div>
  );
};

export default Page;
