"use client";

import React, { useState } from "react";
import { setPopupChildren, togglePopup } from "@/redux/global/globalSlice";
import { AppDispatch, RootState } from "@/redux/store";
import fileService from "@/services/file.service";
import orthancService from "@/services/orthanc.service";
import studyService from "@/services/slide.service";
import {
  convertDateFormat,
  formattedName,
  getDataSet,
  getDistinctParentStudy,
  getDistinctStudiesFromDataset,
  getFileExtension,
  readFileAsBinary,
  setGender,
} from "@/utils/utilities/file";
import { useRouter } from "next/navigation";
import toast from "react-hot-toast";
import { useDispatch, useSelector } from "react-redux";

const useUploadStudy = () => {
  const [file, setFile] = useState<File | null>(null);

  const [isExtracting, setIsExtracting] = useState<boolean>(false);
  const [uploaded, setUploaded] = useState<boolean>(false);
  const [studyDateTime, setStudyDateTime] = useState<string>("");
  const [fileData, setFileData] = useState<any>();
  const [isUploading, setIsUploading] = useState<boolean>(false);
  const [studyData, setStudyData] = useState({
    patientName: "--/--",
    age: "--/--",
    gender: "--/--",
    studyDescription: "--/--",
    studyDate: "--/--",
    fileName: "",
    instanceId: "",
    instancePatientId: "",
    instanceStudyId: "",
    instancePath: "",
    instanceStatus: "",
  });
  const [studyId, setStudyId] = useState<string | number | null>(null);

  const { activeInstitution } = useSelector((state: RootState) => state.user);

  const reduxDispatch = useDispatch<AppDispatch>();
  const router = useRouter();

  // const handleFileUpload = async (file: File) => {
  //   try {
  //     setIsExtracting(true);
  //     console.log(file);
  //     const dataSets = await getDataSet(file);
  //     console.log(dataSets);
  //     const distinctStudies = getDistinctStudiesFromDataset(dataSets);
  //     console.log(distinctStudies);
  //     setFile(file);
  //     setUploaded(true);
  //     setIsExtracting(false);
  //     // setStudyDateTime(
  //     //   String(
  //     //     distinctStudies?.map(
  //     //       (study) => `${study?.StudyDate}|${study?.StudyTime}`,
  //     //     ),
  //     //   ),
  //     // );
  //     if (distinctStudies?.length) {
  //       setStudyDateTime(
  //         distinctStudies
  //           .map((study) => `${study?.StudyDate}|${study?.StudyTime}`)
  //           .join(", "),
  //       );

  //       setFileData(
  //         distinctStudies?.map((d) => ({
  //           originalFileName: file?.name,
  //           fileSize: file?.size,
  //           fileName: formattedName(file.name),
  //           ...(d?.PatientName && { patientName: d?.PatientName }),
  //           ...(d?.Modality && { modality: d?.Modality }),
  //           ...(d?.StudyDescription && {
  //             studyDescription: d?.StudyDescription,
  //           }),
  //           ...(d?.StudyDate && { studyDate: d?.StudyDate }),
  //           ...(d?.StudyTime && { studyTime: d?.StudyTime }),
  //           ...(d?.StudyInstanceUID && {
  //             studyInstanceUID: d?.StudyInstanceUID,
  //           }),
  //         })),
  //       );
  //     }

  //     toast(`You have selected ${file?.name}, and it's ready to be uploaded.`);
  //   } catch (error) {
  //     console.log(error);
  //     setFile(file);
  //     setUploaded(true);
  //     setIsExtracting(false);
  //     setStudyDateTime("");
  //     setFileData(null);
  //   }
  // };

  // const uploadSingleFile = async (file: File) => {
  //   if (getFileExtension(file.name)?.toLowerCase() === "zip") {
  //     const binaryData = await readFileAsBinary(file);

  //     try {
  //       const { data: response } = await orthancService.uploadStudy(binaryData);
  //       const data = Array.isArray(response) ? response : [response];

  //       if (!data || !data.length) {
  //         throw "Unable to process. Unrecognized file upload";
  //       }

  //       const studiesData = getDistinctParentStudy(data);
  //       const totalStudies = studiesData?.length;
  //       const totalPatients = studiesData?.length;

  //       await Promise.all(
  //         studiesData?.map(async (studyData, index) => {
  //           const instanceDetails = studyData;

  //           let processedStudies = 0;

  //           try {
  //             const { data } = await orthancService.getOrtStudyDetail(
  //               instanceDetails?.ParentStudy,
  //             );
  //             const { MainDicomTags, PatientMainDicomTags, RequestedTags } =
  //               data;
  //             setStudyData({
  //               patientName: PatientMainDicomTags?.PatientName || "--/--",
  //               age: PatientMainDicomTags?.PatientBirthDate || "--/--",
  //               gender: setGender(PatientMainDicomTags?.PatientSex) || "--/--",
  //               studyDescription: MainDicomTags?.StudyDescription || "--/--",
  //               studyDate:
  //                 convertDateFormat(MainDicomTags?.StudyDate) || "--/--",

  //               fileName: file?.name || "",
  //               instanceId: instanceDetails?.ID || "",
  //               instancePatientId: instanceDetails?.ParentPatient || "",
  //               instanceStudyId: instanceDetails?.ParentStudy || "",
  //               instancePath: instanceDetails?.Path || "",
  //               instanceStatus: instanceDetails?.Status || "",
  //             });
  //             setFile(file);

  //             const body: Record<string, any> = {};

  //             // if (attachment) body.attachment = attachment;
  //             // if (branchId) body.branchId = branchId;
  //             body.patientName = PatientMainDicomTags.PatientName || "--/--";
  //             if (MainDicomTags?.StudyDescription?.length) {
  //               body.studyDescription = MainDicomTags.StudyDescription;
  //             }
  //             body.fileName = formattedName(file?.name);
  //             body.instanceId = instanceDetails?.ID;
  //             body.instancePatientId = instanceDetails?.ParentPatient;
  //             body.instanceStudyId = instanceDetails?.ParentStudy;
  //             body.modalityInStudy = RequestedTags?.Modality;
  //             body.instancePath = instanceDetails?.Path;
  //             body.instanceStatus = instanceDetails?.Status;
  //             body.studyDate = `${MainDicomTags?.StudyDate}`;
  //             body.studyTime = `${MainDicomTags?.StudyTime}`;
  //             body.fileSize = file?.size;

  //             // const dataUpload =
  //             //   activeInstitution?.id &&
  //             // (await studyService.uploadSlideInstitution({
  //             //   institutionId:activeInstitution?.id,
  //             //   body
  //             // }

  //             // ));

  //             // setStudyId(dataUpload?.data?.id);
  //             // reduxDispatch(setStudyId(dataUpload?.data?.id));

  //             // Increment the counter for processed patients
  //             processedStudies++;

  //             if (studiesData.length > 1) {
  //               // If it's the last iteration and there's more than one patient, navigate to /app/studies
  //               if (processedStudies === totalStudies && totalStudies > 1) {
  //                 reduxDispatch(
  //                   setPopupChildren({
  //                     key: "secondPopup",
  //                     componentKey: "successPrompt",
  //                     props: { body: "File upload is complete" },
  //                   }),
  //                 );
  //                 reduxDispatch(
  //                   togglePopup({ key: "secondPopup", isOpen: true }),
  //                 );

  //                 // reduxDispatch(setPopupChildren());
  //                 setTimeout(() => {
  //                   reduxDispatch(
  //                     togglePopup({ key: "secondPopup", isOpen: false }),
  //                   );
  //                 }, 2500);
  //               }
  //             } else {
  //               // If there's only one patient, navigate based on myHospital type
  //               reduxDispatch(
  //                 setPopupChildren({
  //                   key: "secondPopup",
  //                   componentKey: "successPrompt",
  //                   props: { body: "File upload is complete" },
  //                 }),
  //               );
  //               reduxDispatch(
  //                 togglePopup({ key: "secondPopup", isOpen: true }),
  //               );
  //               setTimeout(() => {
  //                 reduxDispatch(
  //                   togglePopup({ key: "secondPopup", isOpen: false }),
  //                 );
  //                 router.push("/institution/view-studies");
  //               }, 2500);
  //             }
  //           } catch (error) {
  //             toast.error(error?.message || error?.errors, [10]);
  //           } finally {
  //             // If it's the last iteration, dispatch the action to stop uploading and submitting
  //             if (index === totalPatients - 1) {
  //               setIsUploading(false);
  //             }
  //           }
  //         }),
  //       );
  //     } catch (error) {
  //       if (typeof error === "string") {
  //         toast.error(error);
  //       } else if (error?.message) {
  //         toast.error(error?.message);
  //       } else {
  //         toast.error("Something went wrong during DICOM file processing");
  //       }
  //     }
  //   } else if (getFileExtension(file.name)?.toLowerCase() === "dcm") {
  //     try {
  //       const { data: response } = await orthancService.uploadStudy(file);
  //       const data = Array.isArray(response) ? response : [response];

  //       if (!data || !data.length) {
  //         throw new Error("Unable to process. Unrecognized file upload");
  //       }

  //       const studiesData = getDistinctParentStudy(data);
  //       const instanceDetails = data[0];

  //       const { data: studyDetail } = await orthancService.getOrtStudyDetail(
  //         instanceDetails?.ParentStudy,
  //       );

  //       const { MainDicomTags, PatientMainDicomTags, RequestedTags } =
  //         studyDetail;

  //       setStudyData({
  //         patientName: PatientMainDicomTags?.PatientName || "--/--",
  //         age: PatientMainDicomTags?.PatientBirthDate || "--/--",
  //         gender: setGender(PatientMainDicomTags?.PatientSex) || "--/--",
  //         studyDescription: MainDicomTags?.StudyDescription || "--/--",
  //         studyDate: convertDateFormat(MainDicomTags?.StudyDate) || "--/--",

  //         fileName: file?.name || "",
  //         instanceId: instanceDetails?.ID || "",
  //         instancePatientId: instanceDetails?.ParentPatient || "",
  //         instanceStudyId: instanceDetails?.ParentStudy || "",
  //         instancePath: instanceDetails?.Path || "",
  //         instanceStatus: instanceDetails?.Status || "",
  //       });
  //       setFile(file);

  //       const body: Record<string, any> = {};

  //       // if (attachment) body.attachment = attachment;
  //       // if (branchId) body.branchId = branchId;
  //       body.patientName = PatientMainDicomTags.PatientName || "--/--";
  //       if (MainDicomTags?.StudyDescription?.length) {
  //         body.studyDescription = MainDicomTags.StudyDescription;
  //       }
  //       body.fileName = formattedName(file?.name);
  //       body.instanceId = instanceDetails?.ID;
  //       body.instancePatientId = instanceDetails?.ParentPatient;
  //       body.instanceStudyId = instanceDetails?.ParentStudy;
  //       body.modalityInStudy = RequestedTags?.Modality;
  //       body.instancePath = instanceDetails?.Path;
  //       body.instanceStatus = instanceDetails?.Status;
  //       body.studyDate = `${MainDicomTags?.StudyDate}`;
  //       body.studyTime = `${MainDicomTags?.StudyTime}`;
  //       body.fileSize = file?.size;

  //       // if (activeInstitution) {
  //       //   const { data: studyData } = await studyService.uploadStudyInst(
  //       //     activeInstitution?.id,
  //       //     body,
  //       //   );
  //       //   setStudyId(studyData?.id);
  //       //   reduxDispatch(
  //       //     setPopupChildren({
  //       //       key: "secondPopup",
  //       //       componentKey: "successPrompt",
  //       //       props: { body: "File upload is complete" },
  //       //     }),
  //       //   );
  //       //   reduxDispatch(togglePopup({ key: "secondPopup", isOpen: true }));
  //       //   setTimeout(() => {
  //       //     reduxDispatch(togglePopup({ key: "secondPopup", isOpen: false }));
  //       //     router.push("/institution/view-studies");
  //       //   }, 2500);
  //       // }
  //     } catch (error) {
  //       console.error(error);
  //       toast.error(
  //         error?.message ||
  //           error?.errors ||
  //           "Something went wrong during DICOM file processing",
  //       );
  //     } finally {
  //       setIsUploading(false);
  //     }
  //   } else {
  //     toast.error("Unsupported file type");
  //     return;
  //   }
  // };

  // const onCustomUpload = async (file: File) => {
  //   try {
  //     setIsUploading(true);

  //     const uploadStatusRequest = async () => {
  //       if (!!activeInstitution?.id)
  //         fileService.uploadStatusInst({
  //           fileName: formattedName(file.name),
  //           institutionId: activeInstitution?.id,
  //           data: fileData,
  //           studiesDateTime: studyDateTime,
  //         });
  //     };

  //     const fileStatusResponse = await uploadStatusRequest();

  //     if (fileStatusResponse?.data?.status === "already_exist") {
  //       reduxDispatch(
  //         setPopupChildren({
  //           key: "secondPopup",
  //           componentKey: "alertPrompt",
  //           props: { body: "This file has already been uploaded" },
  //         }),
  //       );
  //       reduxDispatch(togglePopup({ key: "secondPopup", isOpen: true }));
  //     } else {
  //       await uploadSingleFile(file);
  //     }
  //   } catch (error) {
  //     console.log("Error uploading file:", error);

  //     if (error?.message?.includes("File id can't be identified")) {
  //       await uploadSingleFile(file);
  //     } else if (error?.message && typeof error?.message === "string")
  //       toast.error("Error uploading file");
  //     toast.error(error?.message);
  //     setIsUploading(false);
  //   } finally {
  //     setIsUploading(false);
  //   }
  // };

  // const handleSubmitStudy = () => {
  //   if (!file) {
  //     return toast.error("Please upload a valid DICOM file.");
  //   }

  //   onCustomUpload(file);
  // };

  return {
    file,
    isExtracting,
    uploaded,
    // handleFileUpload,
    // handleSubmitStudy,
    isUploading,
  };
};

export default useUploadStudy;
