"use client";

import React, { useEffect, useState } from "react";
import { Button } from "@/components/Buttons";
import { PhoneInput, SelectInput, TextInput } from "@/components/Inputs";
import {
  INSTITUTION_PROFILE_SCHEMA,
  INSTITUTION_USER_PROFILE_SCHEMA,
} from "@/utils/validationSchema/institution.schema";
import { Form, Formik } from "formik";
import { allCountries } from "country-region-data";
import { institutionTypes } from "@/app/auth/contants";
import { useSelector } from "react-redux";
import { RootState } from "@/redux/store";
import { UserRole } from "@/interfaces";
import Loading from "@/components/Loading/Loading";

interface FormValuesInstitution {
  institutionName: string;
  institutionType?:
    | "MEDICAL_CENTER"
    | "DIAGNOSTIC_CENTER"
    | "HOSPITAL"
    | "GROUP_OF_RADIOLOGISTS"
    | "OTHERS";
  institutionPhone: string;
  institutionEmail: string;
  institutionCountry: string;
  institutionAddress: string;
}
interface FormValuesUser {
  firstName: string;
  lastName: string;
  role?: UserRole | string;
  phone: string;
  email: string;
}
const Page = () => {
  const { activeRole, activeUser, activeInstitution } = useSelector(
    (state: RootState) => state.user,
  );

  const [isLoading, setIsLoading] = useState<boolean>(false);
  const [loadingPage, setLoadingPage] = useState<boolean>(true);

  const initialValues: FormValuesInstitution = {
    institutionName: activeInstitution?.institutionName || "",
    institutionType: activeInstitution?.institutionType,
    institutionPhone: `${activeInstitution?.phoneCode || "+234"}${activeInstitution?.phoneNumber || ""}`,
    institutionEmail: activeInstitution?.institutionEmail || "",
    institutionCountry: activeInstitution?.country || "",
    institutionAddress: activeInstitution?.address || "",
  };
  const initialValuesUser: FormValuesUser = {
    firstName: activeUser?.firstName || "",
    lastName: activeUser?.lastName || "",
    role: activeRole || "",
    phone: `${activeUser?.phoneCode || "+234"}${activeUser?.phoneNumber || ""}`,
    email: activeUser?.email || "",
  };

  useEffect(() => {
    if (activeRole !== null) {
      setLoadingPage(false);
    }
  }, [activeRole]);

  const countryData = allCountries
    ?.map((country) => ({
      value: country[1],
      label: country[0],
    }))
    .filter((count) => count.value === "NG");

  if (loadingPage)
    return (
      <div className="relative h-full max-w-[600px] rounded-[8px] border border-greyStroke bg-whiteShade p-10">
        <Loading
          className={{
            loader: "!w-[40px]",
            loaderText: "text-lg text-grey",
          }}
          loaderText="Loading Profile..."
        />
      </div>
    );
  if (activeRole === "SUPERADMIN")
    return (
      <div className="max-w-[600px] rounded-[8px] border border-greyStroke bg-whiteShade p-10">
        <Formik
          initialValues={initialValues}
          validationSchema={INSTITUTION_PROFILE_SCHEMA}
          onSubmit={(values) => console.log(values)}
        >
          {() => (
            <Form className="flex flex-col gap-3">
              <TextInput
                name="institutionName"
                type="text"
                label="Institution Name"
                placeholder="John"
                disabled={isLoading}
              />

              <SelectInput
                name="institutionType"
                label="Type of Institution"
                options={institutionTypes}
                disabled={true}
                type="primary"
                placeholder=""
                className={{
                  content: "w-full",
                  trigger:
                    "h-[40px] w-full rounded-[4px] border-greyLine text-blackMain outline-none",
                }}
              />

              <PhoneInput name="institutionPhone" label="Phone No." />

              <TextInput
                name="institutionEmail"
                type="email"
                label="Institution Email"
                placeholder="Enter your email"
                disabled={true}
              />
              <SelectInput
                name="institutionCountry"
                label="Institution Country"
                options={countryData}
                disabled={isLoading}
                type="primary"
                placeholder=""
                className={{
                  content: "w-full",
                  trigger:
                    "h-[40px] w-full rounded-[4px] border-greyLine text-blackMain outline-none",
                }}
              />
              <TextInput
                name="institutionAddress"
                type="text"
                label="Address"
                placeholder="XYZ Street..."
                disabled={isLoading}
              />

              <div className="mt-10 flex justify-end">
                <Button
                  disabled={true}
                  type="submit"
                  variant="primary"
                  loading={isLoading}
                >
                  Update
                </Button>
              </div>
            </Form>
          )}
        </Formik>
      </div>
    );

  return (
    <div className="max-w-[600px] rounded-[8px] border border-greyStroke bg-whiteShade p-10">
      <Formik
        initialValues={initialValuesUser}
        validationSchema={INSTITUTION_USER_PROFILE_SCHEMA}
        onSubmit={(values) => console.log(values)}
      >
        {() => (
          <Form className="flex flex-col gap-3">
            <TextInput
              name="firstName"
              type="text"
              label="First Name"
              placeholder="John"
              disabled={isLoading}
            />
            <TextInput
              name="lastName"
              type="text"
              label="Last Name"
              placeholder="Doe"
              disabled={isLoading}
            />
            <SelectInput
              name="role"
              label="Role"
              options={institutionTypes}
              disabled={true}
              type="primary"
              placeholder=""
              className={{
                content: "w-full",
                trigger:
                  "h-[40px] w-full rounded-[4px] border-greyLine text-blackMain outline-none",
              }}
            />

            <PhoneInput name="phone" label="Phone No." />

            <TextInput
              name="email"
              type="email"
              label="Email"
              placeholder="Enter your email"
              disabled={true}
            />

            {/* <TextInput
              name="institutionAddress"
              type="text"
              label="Address"
              placeholder="XYZ Street..."
              disabled={isLoading}
            /> */}

            <div className="mt-10 flex justify-end">
              <Button
                disabled={true}
                type="submit"
                variant="primary"
                loading={isLoading}
              >
                Update
              </Button>
            </div>
          </Form>
        )}
      </Formik>
    </div>
  );
};

export default Page;
