"use client";

import { Button } from "@/components/Buttons";
import { TextInput } from "@/components/Inputs";
import authService from "@/services/auth.service";
import { CHANGE_PASSWORD_SCHEMA } from "@/utils/validationSchema/institution.schema";
import { Form, Formik } from "formik";
import React, { useState } from "react";
import toast from "react-hot-toast";

interface FormValues {
  oldPassword: string;
  newPassword: string;
  confirmPassword: string;
}
const Page = () => {
  const [isLoading, setIsLoading] = useState<boolean>(false);

  const initialValues: FormValues = {
    oldPassword: "",
    newPassword: "",
    confirmPassword: "",
  };

  const handleChangePassword = async (
    values: FormValues,
    { resetForm }: { resetForm: () => void },
  ) => {
    setIsLoading(true);
    authService
      .changePassword(values)
      .then((res) => {
        toast.success(res.message);
        resetForm();
      })

      .catch((error) => {
        console.log(error);
        toast.error(error?.message || error?.errors);
      })
      .finally(() => {
        setIsLoading(false);
      });
  };

  return (
    <div className="max-w-[600px] rounded-[8px] border border-greyStroke bg-whiteShade p-10">
      <Formik
        initialValues={initialValues}
        validationSchema={CHANGE_PASSWORD_SCHEMA}
        onSubmit={handleChangePassword}
      >
        {({ resetForm }) => (
          <Form className="flex flex-col gap-3">
            <TextInput
              name="oldPassword"
              type="password"
              label="Current Password"
              placeholder="xxx xxx"
              disabled={isLoading}
            />
            <TextInput
              name="newPassword"
              type="password"
              label="New Password"
              placeholder="xxx xxx"
              disabled={isLoading}
            />
            <TextInput
              name="confirmPassword"
              type="password"
              label="Confirm Password"
              placeholder="xxx xxx"
              disabled={isLoading}
            />

            <div className="mt-10 flex justify-between">
              <Button type="button" variant="gray" onClick={() => resetForm()}>
                Clear
              </Button>
              <Button type="submit" variant="primary" loading={isLoading}>
                Update
              </Button>
            </div>
          </Form>
        )}
      </Formik>
    </div>
  );
};

export default Page;
