"use client";

import { Button } from "@/components/Buttons";
import PageHeader from "@/components/common/PageHeader";
import { ActionDropdown } from "@/components/Dropdowns/ActionDropdown";
import { ColumnConfig, generateColumns } from "@/components/Table/column";
import { DataTable } from "@/components/Table/DataTable";
import { setPopupChildren, togglePopup } from "@/redux/global/globalSlice";
import { AppDispatch, RootState } from "@/redux/store";
// import { useRouter } from "next/navigation";
import React, { useEffect, useState } from "react";
import { BsThreeDotsVertical } from "react-icons/bs";
import {
  // MdClose,
  MdOutlineAdd,
  MdOutlineDelete,
  // MdOutlineUndo,
  // MdRemoveRedEye,
  MdUpdate,
} from "react-icons/md";
import { useDispatch, useSelector } from "react-redux";
import usePathologists from "./hooks/usePathologists";
import { User } from "@/interfaces";

type Pathologist = {
  id: string;
  invitedAt: Date | string;
  status: string;
  type: string;
  pathologist: {
    id: number;
    verified: boolean;
    createdAt: Date | string;
    user: User;
    type: string;
  };
};

const Page = () => {
  const reduxDispatch = useDispatch<AppDispatch>();
  // const router = useRouter();

  const { pathologists } = useSelector((state: RootState) => state.data);
  const { activeInstitution } = useSelector((state: RootState) => state.user);

  const { getPathologists, loadingPathologists, search, handleSearch } =
    usePathologists();

  useEffect(() => {
    getPathologists(search);
  }, [activeInstitution?.id]);

  const onUpdateType = (body: Pathologist) => {
    reduxDispatch(
      setPopupChildren({
        key: "firstPopup",
        componentKey: "managePathologistType",
        props: {
          body: body,
        },
      }),
    );
    reduxDispatch(togglePopup({ key: "firstPopup", isOpen: true }));
  };

  // const confirmToggleMakeActive = () => {
  //   reduxDispatch(
  //     setPopupChildren({
  //       key: "firstPopup",
  //       componentKey: "prompt",
  //       props: {
  //         title: "Toggle Active ",
  //         bodyText:
  //           "You are about to enable John Doe ability to interpret studies",
  //         buttonText: "Activate",
  //         onCloseKey: "firstPopup",
  //       },
  //     }),
  //   );
  //   reduxDispatch(togglePopup({ key: "firstPopup", isOpen: true }));
  // };
  const confirmToggleRemove = (user: {
    id: number;
    verified: boolean;
    createdAt: Date | string;
    user: User;
    type: string;
  }) => {
    reduxDispatch(
      setPopupChildren({
        key: "firstPopup",
        componentKey: "removePathologistPrompt",
        props: {
          user: user,
          onCloseKey: "firstPopup",
        },
      }),
    );
    reduxDispatch(togglePopup({ key: "firstPopup", isOpen: true }));
  };
  // const confirmToggleSuspend = () => {
  //   reduxDispatch(
  //     setPopupChildren({
  //       key: "firstPopup",
  //       componentKey: "prompt",
  //       props: {
  //         title: "Are you sure you want to suspend this account?",
  //         bodyText:
  //           "This action will temporarily deactivate this account from the platform until reactivated. Click 'Suspend' to confirm action.",
  //         buttonText: "Suspend",
  //         onCloseKey: "firstPopup",
  //       },
  //     }),
  //   );
  //   reduxDispatch(togglePopup({ key: "firstPopup", isOpen: true }));
  // };

  const pathologistColumn: ColumnConfig<Pathologist>[] = [
    {
      key: "name",
      header: "Name",
      cell: ({ row }) => {
        return (
          <div className="whitespace-nowrap">{`${row.original.pathologist.user.firstName} ${row.original.pathologist.user.lastName}`}</div>
        );
      },
    },
    {
      key: "email",
      header: "Email",
      cell: ({ row }) => {
        return <div>{row.original.pathologist.user.email}</div>;
      },
    },
    {
      key: "type",
      header: "Type",
      cell: ({ row }) => {
        return <div className="capitalize">{row.original.type}</div>;
      },
    },
    {
      key: "status",
      header: "Status",
    },
    {
      key: "action",
      header: <p className="text-center">Action</p>,
      cell: ({ row }) => {
        return (
          <ActionDropdown
            theme="primary"
            align="end"
            className={{
              content: "w-fit bg-greyStroke",
              item: "hover:bg-white",
            }}
            trigger={
              <div className="flex justify-center">
                <BsThreeDotsVertical />
              </div>
            }
            options={[
              // {
              //   label: <div>View Account</div>,
              //   onClick: () => {
              //     router.push(
              //       `/institution/pathologists/${row.original.pathologist.id}`,
              //     );
              //   },
              //   icon: <MdRemoveRedEye />,
              // },
              // {
              //   label: <div>Make Active</div>,
              //   onClick: () => {
              //     confirmToggleMakeActive();
              //   },
              //   icon: <MdOutlineUndo />,
              // },
              {
                label: <div>Change Type</div>,
                onClick: () => {
                  onUpdateType(row.original);
                },
                icon: <MdUpdate />,
              },

              {
                label: <div>Remove</div>,
                onClick: () => {
                  confirmToggleRemove(row.original.pathologist);
                },
                icon: <MdOutlineDelete />,
              },
              // {
              //   label: <div>Suspend</div>,
              //   onClick: () => {
              //     confirmToggleSuspend();
              //   },
              //   icon: <MdClose />,
              // },
            ]}
            // options={[]}
          />
        );
      },
    },
  ];

  const columns = generateColumns(pathologistColumn, {
    select: true,
    serialNumber: true,
  });

  const [filteredData, setFilteredData] = useState<Pathologist[]>(pathologists);

  useEffect(() => {
    setFilteredData(pathologists);
  }, [pathologists]);

  const handleChange = (e: React.ChangeEvent<HTMLInputElement>) => {
    handleSearch(e);
  };

  const onAddPathologist = () => {
    reduxDispatch(
      setPopupChildren({
        key: "firstPopup",
        componentKey: "managePathologist",
      }),
    );
    reduxDispatch(togglePopup({ key: "firstPopup", isOpen: true }));
  };

  return (
    <div className="flex flex-col gap-4 px-2 py-6 md:px-8">
      <Button
        iconPrefix={<MdOutlineAdd size={20} />}
        variant="gradient"
        className="text-md ml-auto p-6"
        onClick={onAddPathologist}
      >
        Add Pathologist
      </Button>
      <PageHeader
        title="Pathologists"
        body="View all  pathologists registered with your institution"
      />

      <div className="">
        <DataTable
          theme={"primary"}
          data={filteredData}
          columns={columns}
          search={{ ...search, handleChange }}
          Loader={{
            isLoading: loadingPathologists,
            loaderText: "Loading Pathologists...",
          }}
        />
      </div>
    </div>
  );
};

export default Page;
