"use client";

import InsideCallPanel from "@/components/CallPanel/InsideCallPanel";
import PageSkeleton from "@/components/Loading/PageSkeleton";
import Navbar from "@/components/Navbar/Navbar";
import SideBar from "@/components/SideBar/SideBar";
import { SidebarInset, SidebarProvider } from "@/components/ui/sidebar";
import { UserInstitution } from "@/interfaces";
import { AppDispatch, RootState } from "@/redux/store";
import {
  setActiveInstitution,
  setActiveRole,
  setActiveUser,
} from "@/redux/user/userSlice";
import {
  getSessionActiveInstitutionId,
  getSessionActiveRole,
  getToken,
  getUserData,
} from "@/utils/sessions/session.utils";
import { useRouter } from "next/navigation";
import React, { useEffect, useState } from "react";
import { useDispatch, useSelector } from "react-redux";
import Smartlook from "smartlook-client";

export default function Layout({ children }: { children: React.ReactNode }) {
  const reduxDispatch = useDispatch<AppDispatch>();
  const router = useRouter();
  const [layoutLoading, setLayoutLoading] = useState<boolean>(true);

  const { onCall } = useSelector((state: RootState) => state.call);

  useEffect(() => {
    const initializeState = async () => {
      try {
        const storedUser = getUserData();
        const storedInstitutionId = getSessionActiveInstitutionId();
        const storedRole = getSessionActiveRole();
        const storedToken = getToken();

        if (!storedToken) {
          router.push("/auth/login");
          return;
        }

        if (!storedUser) {
          router.push("/auth/login");
          return;
        }

        reduxDispatch(setActiveUser(storedUser));

        if (storedRole) {
          reduxDispatch(setActiveRole(storedRole));
        }

        if (storedInstitutionId && storedRole && storedUser) {
          const foundInstitution = storedUser?.userInstitutions?.find(
            (userInt: UserInstitution) =>
              userInt.role === storedRole &&
              userInt.institution.id === storedInstitutionId,
          );

          if (foundInstitution) {
            reduxDispatch(setActiveInstitution(foundInstitution.institution));
          }
        }

        await new Promise((resolve) => setTimeout(resolve, 100));

        if (!storedInstitutionId || !storedRole) {
          router.push("/auth/account-select");
          return;
        }

        // Initialize Smartlook after user data is loaded
        Smartlook.identify("user", {
          email: storedUser?.email || "",
        });
      } catch (error) {
        console.error("Error loading layout:", error);
      } finally {
        setLayoutLoading(false);
      }
    };
    initializeState();
  }, []);

  return (
    <SidebarProvider defaultOpen={true} className="h-screen max-w-[2560px]">
      <SideBar />
      <SidebarInset className="overflow-hidden bg-greyLineLight">
        {layoutLoading ? (
          <PageSkeleton />
        ) : (
          <>
            <Navbar />
            <div className="flex-1 overflow-auto">{children}</div>
          </>
        )}
      </SidebarInset>
      {onCall && <InsideCallPanel />}
    </SidebarProvider>
  );
}
