"use client";

import { useRouter } from "next/navigation";
import React, { useEffect, useMemo } from "react";
import {
  MdOutlineCloudUpload,
  MdOutlinePeopleAlt,
  MdOutlineTableChart,
  MdOutlineLibraryBooks,
} from "react-icons/md";
import Links from "./components/Links";
import DashCard from "./components/DashCard";
import LineChart from "./components/LineChart";
import StudySummary from "./components/StudySummary";
import useDashboard from "./hooks/useDashboard";
import PageSkeleton from "@/components/Loading/PageSkeleton";
import { useSelector } from "react-redux";
import { RootState } from "@/redux/store";
import { generateGreeting } from "@/utils/utilities";

const Page = () => {
  const router = useRouter();
  const { activeInstitution } = useSelector((state: RootState) => state.user);
  const { dashboard } = useSelector((state: RootState) => state.data);

  const { isLoading, getDashboardData, generateUserName } = useDashboard();

  useEffect(() => {
    getDashboardData();
  }, [activeInstitution?.id]);

  const { dash, distribution, statistic } = dashboard;

  const cardData = useMemo(
    () => [
      {
        label: "Slides",
        value: dash?.totalSlideImages || 0,
        icon: MdOutlineLibraryBooks,
      },
      {
        label: "Reports",
        value: dash?.totalReports || 0,
        icon: MdOutlineLibraryBooks,
      },
      {
        label: "Pathologists",
        value: dash?.totalPathologists || 0,
        icon: MdOutlineLibraryBooks,
      },
    ],
    [dash],
  );

  const quickLinks = [
    {
      label: "View Studies",
      icon: <MdOutlineTableChart size={20} />,
      click: () => router.push("/institution/view-studies"),
    },
    {
      label: "Add Pathologist",
      icon: <MdOutlinePeopleAlt size={20} />,
      click: () => router.push("/institution/pathologists"),
    },
    {
      label: "Upload Studies",
      icon: <MdOutlineCloudUpload size={20} />,
      click: () => router.push("/institution/upload-studies"),
    },
  ];

  return isLoading ? (
    <PageSkeleton />
  ) : (
    <div className="flex flex-col gap-4 px-2 py-6 md:px-8">
      <div className="space-y-4">
        <div>
          <p className="truncate text-xl font-semibold text-grey md:text-2xl">
            {`${generateGreeting()}, ${generateUserName()}`}
          </p>
        </div>
        <div className="grid w-full grid-cols-1 gap-3 sm:grid-cols-2 sm:gap-6 lg:grid-cols-3">
          {cardData.map((item, idx) => (
            <React.Fragment key={idx}>
              <DashCard card={item} />
            </React.Fragment>
          ))}
        </div>
      </div>
      <div className="flex flex-col gap-8">
        <div className="space-y-2">
          <div className="text-xl font-medium text-grey md:text-2xl">
            Quick Links
          </div>
          <div className="flex flex-wrap gap-2 gap-y-2 md:gap-4">
            {quickLinks.map((quickLink, idx) => {
              return (
                <React.Fragment key={idx}>
                  <Links link={quickLink} />
                </React.Fragment>
              );
            })}
          </div>
        </div>
        <div className="grid grid-cols-12 gap-4">
          <div className="col-span-12 lg:col-span-8">
            <LineChart data={distribution} />
          </div>
          <div className="col-span-12 lg:col-span-4">
            <StudySummary data={statistic} />
          </div>
        </div>
      </div>
    </div>
  );
};

export default Page;
