import { setDashboard } from "@/redux/data/dataSlice";
import { AppDispatch, RootState } from "@/redux/store";
import institutionService from "@/services/institution.service";
import React, { useState } from "react";
import toast from "react-hot-toast";
import { useDispatch, useSelector } from "react-redux";

const useDashboard = () => {
  const reduxDispatch = useDispatch<AppDispatch>();
  const [isLoading, setIsLoading] = useState<boolean>(true);

  const { activeInstitution, activeUser } = useSelector(
    (state: RootState) => state.user,
  );
  const { dashboard } = useSelector((state: RootState) => state.data);

  const getDashboardData = () => {
    if (!activeInstitution) return;

    if (!dashboard.distribution.length) {
      setIsLoading(true);
    } else setIsLoading(false);

    Promise.all([
      institutionService.getInstitutionStatistics({
        institutionId: activeInstitution.id,
      }),
      institutionService.getInstitutionDashboard({
        institutionId: activeInstitution.id,
      }),
      institutionService.getInstitutionDistribution({
        institutionId: activeInstitution.id,
      }),
    ])
      .then(([stats, dashboard, distribution]) => {
        reduxDispatch(
          setDashboard({
            distribution: distribution?.data as any[],
            statistic: stats?.data,
            dash: dashboard?.data,
          }),
        );
      })
      .catch((error) => {
        console.error(error);
        toast.error(error?.message || error?.errors);
      })
      .finally(() => setIsLoading(false));
  };

  const generateUserName = () => {
    return `${activeUser?.firstName || ""} ${activeUser?.lastName || ""}`;
  };

  return {
    isLoading,
    getDashboardData,
    generateUserName,
  };
};

export default useDashboard;
