import React from "react";
import CountUp from "react-countup";
import StudyCount from "./StudyCount";
import {
  MdOutlineBusinessCenter,
  MdOutlineCloudUpload,
  MdOutlineLibraryBooks,
} from "react-icons/md";
import { formatSizeInBytes } from "@/utils/utilities";
import ModalityCount from "./ModalityCount";
import { modalityColor } from "@/utils/utilities/constant";

const StudySummary = ({ data }: { data: any }) => {
  const totalSlides = Number(data?.totalSlideImages || 0);

  const totalSlideSize = formatSizeInBytes(data?.totalSlideImagesSize);

  const totalAssigned = Number(data?.totalAssigned || 0);
  const totalReported = Number(data?.totalReported || 0);
  const totalES = Number(data?.modalities?.ES || 0);
  const totalGM = Number(data?.modalities?.GM || 0);
  const totalOP = Number(data?.modalities?.OP || 0);
  const totalSM = Number(data?.modalities?.SM || 0);
  const totalXC = Number(data?.modalities?.XC || 0);
  const totalOthers = Number(data?.modalities?.Others || 0);

  return (
    <div className="h-full max-h-full min-h-[400px] overflow-hidden rounded-[8px] border border-greyStroke bg-whiteShade">
      <div
        style={{
          background: `linear-gradient(153.26deg, #B3E0E5 -49.91%, rgba(179, 224, 229, 0.3) 64.58%)`,
        }}
        className="flex justify-between px-6 pb-6 pt-8"
      >
        <div className="flex flex-col justify-center">
          <h4 className="mb-0 text-[18px] font-semibold text-blackMain md:text-[20px]">
            Total Studies
          </h4>
          <h3 className="mx:text-[36px] mb-0 text-2xl font-semibold text-blackMain md:text-[26px]">
            <CountUp start={0} end={totalSlides} delay={0.5} />
          </h3>
          <p className="m-0 mt-2 text-[15px] font-semibold text-greySecondary">
            Size: {totalSlideSize}
          </p>
        </div>
        <div className="w-[45%]">
          <StudyCount
            icon={<MdOutlineCloudUpload />}
            title="Uploaded"
            count={totalSlides}
          />
          <StudyCount
            icon={<MdOutlineBusinessCenter />}
            title="Assigned"
            count={totalAssigned}
          />
          <StudyCount
            icon={<MdOutlineLibraryBooks />}
            title="Reported"
            count={totalReported}
          />
        </div>
      </div>
      <div className="h-full max-h-[300px] overflow-y-auto px-6 py-6">
        {totalSlides === 0 ? (
          <p className="max-w-[90%] text-center font-semibold text-greyDisabled">
            No data found. Upload studies to view analytics and the list of
            available modalities.
          </p>
        ) : (
          <div className="w-full">
            <div className="mb-2 flex items-center justify-between text-[15px] font-semibold text-greySecondary">
              <h3 className="font-semibold text-grey">Modality</h3>
              <div className="grid w-[50%] grid-cols-1 gap-8">
                <h3 className="text-center font-semibold text-grey">
                  Quantity
                </h3>
                {/* <h3 className="text-grey font-semibold text-center">Size</h3> */}
              </div>
            </div>
            <ModalityCount
              color={modalityColor["ES"]}
              title="ES"
              count={totalES}
            />
            <ModalityCount
              color={modalityColor["GM"]}
              title="GM"
              count={totalGM}
            />
            <ModalityCount
              color={modalityColor["OP"]}
              title="OP"
              count={totalOP}
            />
            <ModalityCount
              color={modalityColor["SM"]}
              title="SM"
              count={totalSM}
            />
            <ModalityCount
              color={modalityColor["XC"]}
              title="XC"
              count={totalXC}
            />
            <ModalityCount
              color={modalityColor["Others"]}
              title="Others"
              count={totalOthers}
            />
          </div>
        )}
      </div>
    </div>
  );
};

export default StudySummary;
