import React from "react";

const ModalityCount = ({
  color,
  title,
  count,
}: {
  color: string;
  title: string;
  count: number;
  size?: string;
}) => {
  return (
    <div className="mb-2 flex items-center justify-between text-[15px] font-semibold text-[#828A8B]">
      {/* Left Column */}
      <h3 className="flex items-center gap-2">
        <span
          style={{ background: color }}
          className="h-[14px] w-[14px] rounded-[2px]"
        ></span>{" "}
        {title}
      </h3>

      {/* Right Columns */}
      <div className="grid w-[50%] grid-cols-1 gap-4">
        <p className="m-0 text-center">{count}</p>
        {/* <p className="m-0 text-right">{size}</p> */}
      </div>
    </div>
  );
};

export default ModalityCount;
