import React from "react";

interface Props {
  link: {
    icon: React.ReactNode;
    label: string;
    click: () => void;
  };
}

const Links = ({ link: { click, icon, label } }: Props) => {
  return (
    <div
      className={`flex cursor-pointer items-center gap-2 rounded-3xl border border-greyStroke bg-lightGreenLightest px-3 py-2 text-sm font-medium text-greySecondary shadow-sm transition-all duration-300 ease-in-out hover:scale-95 hover:bg-lightGreenLight md:px-4 md:text-[16px]`}
      onClick={click}
    >
      {icon}
      {label}
    </div>
  );
};

export default Links;
