import { Institution, User, UserInstitution } from "@/interfaces";
import { AppDispatch, RootState } from "@/redux/store";
import { setActiveInstitution, setActiveUser } from "@/redux/user/userSlice";
import institutionService from "@/services/institution.service";
import userService from "@/services/user.service";
import {
  getSessionActiveInstitutionId,
  getSessionActiveRole,
  setSessionUserData,
} from "@/utils/sessions/session.utils";
import toast from "react-hot-toast";
import { useDispatch, useSelector } from "react-redux";

const useFetchData = () => {
  const reduxDispatch = useDispatch<AppDispatch>();
  const { activeInstitution } = useSelector((state: RootState) => state.user);

  const getInstitutionData = () => {
    if (!activeInstitution) return;
    institutionService
      .getInstitutionDetails({ institutionId: activeInstitution?.id })
      .then((res) => {
        reduxDispatch(setActiveInstitution(res.data as Institution));
      })
      .catch((error) => {
        console.log(error);
        toast.error(error?.message || error?.errors);
      });
  };

  const getUserDetails = async () => {
    userService
      .getUserDetails()
      .then((res) => {
        const user = res.data;

        const storedInstitutionId = getSessionActiveInstitutionId();
        const storedRole = getSessionActiveRole();

        reduxDispatch(setActiveUser(user as User));
        setSessionUserData(user as User);

        const foundInstitution = user?.userInstitutions?.find(
          (userInt: UserInstitution) =>
            userInt.role === storedRole &&
            userInt.institution.id === storedInstitutionId,
        );

        if (foundInstitution) {
          reduxDispatch(setActiveInstitution(foundInstitution.institution));
        }
      })
      .catch((error) => {
        toast.error(error?.message || error?.errors);
      });
  };

  return { getInstitutionData, getUserDetails };
};

export default useFetchData;
