import { Button } from "@/components/Buttons";
import { PhoneInput, TextInput } from "@/components/Inputs";
import { Checkbox } from "@/components/ui/checkbox";
import { togglePopup } from "@/redux/global/globalSlice";
import { AppDispatch } from "@/redux/store";
import { Form, Formik } from "formik";
import React, { useState } from "react";
import { useDispatch } from "react-redux";

interface Props {
  isReportAvailable?: boolean;
}

interface FormValues {
  email?: string;
  name: string;
  phone?: string;
}

const ManageSendWhatsapp = ({ isReportAvailable = true }: Props) => {
  const reduxDispatch = useDispatch<AppDispatch>();
  const [whatsappCheck, setWhatsappCheck] = useState<boolean>(false);
  const [emailCheck, setEmailCheck] = useState<boolean>(true);
  const [reportCheck, setReportCheck] = useState<boolean>(false);

  const initialValues: FormValues = {
    email: "",
    name: "",
    phone: "",
  };

  const onChangeEmail = (value: boolean) => {
    setEmailCheck(value);
  };
  const onChangeWhatsapp = (value: boolean) => {
    setWhatsappCheck(value);
  };
  const onChangeReport = (value: boolean) => {
    setReportCheck(value);
  };

  return (
    <div className="flex h-[500px] w-[80vw] flex-col rounded-lg bg-white sm:w-[500px]">
      <div className="mb-3 px-3 pb-3 pt-8 text-center shadow-sm sm:px-8">
        <span className="text-xl font-semibold text-grey">
          Send Medical Image
        </span>
      </div>
      <div className="relative flex flex-1 flex-col overflow-auto px-3 pb-4 pt-2 sm:px-8">
        <p className="text text-center font-medium text-greySecondary">
          Send report to individuals or partners
        </p>

        <Formik
          initialValues={initialValues}
          onSubmit={(values) => console.log(values)}
        >
          {() => (
            <Form className="mt-2" id="mangaeSendWhatsapp">
              <TextInput
                name="name"
                type="text"
                label="Name"
                placeholder="Type the name of the contact you wish to send to"
                //   disabled={isLoading}
              />

              <div className="mb-2 mt-4 flex items-center justify-start gap-4">
                <div className="flex items-center gap-1">
                  <Checkbox
                    onCheckedChange={onChangeEmail}
                    checked={emailCheck}
                  />
                  <span className="text-[13px] font-medium text-grey">
                    Send to Email
                  </span>
                </div>
                <div className="flex items-center gap-1">
                  <Checkbox
                    onCheckedChange={onChangeWhatsapp}
                    checked={whatsappCheck}
                  />

                  <span className="text-[13px] font-medium text-grey">
                    Send to Whatsapp
                  </span>
                </div>
              </div>
              {isReportAvailable && (
                <div className="mb-3 flex items-center gap-1">
                  <Checkbox
                    onCheckedChange={onChangeReport}
                    checked={reportCheck}
                  />

                  <span className="text-[13px] font-medium text-grey">
                    Send with Report{" "}
                  </span>
                </div>
              )}
              {emailCheck && (
                <div>
                  <TextInput
                    name="email"
                    type="email"
                    label="Email Address"
                    //   disabled={isLoading}
                    placeholder="Type the valid email address of your contact"
                  />
                </div>
              )}
              {whatsappCheck && (
                <div>
                  <PhoneInput
                    name="phone"
                    label="Whatsapp Phone No."
                    //   disabled={isLoading}
                  />
                </div>
              )}
            </Form>
          )}
        </Formik>
      </div>
      <div className="flex w-full justify-between border-t-2 border-greyStroke px-3 py-6 sm:px-8">
        <Button
          variant="gray"
          type="button"
          onClick={() =>
            reduxDispatch(togglePopup({ key: "firstPopup", isOpen: false }))
          }
        >
          Cancel
        </Button>
        <Button
          variant="primary"
          type="submit"
          form="mangaeSendWhatsapp"
          // loading={isLoading}
        >
          Add
        </Button>
      </div>
    </div>
  );
};

export default ManageSendWhatsapp;
