"use client";

import { AppDispatch, RootState } from "@/redux/store";
import { useSearchParams } from "next/navigation";
import React, { useMemo, useState } from "react";
import { useDispatch, useSelector } from "react-redux";
import env from "../../../../env";
import { setExternalViewerData } from "@/redux/data/dataSlice";
import slideService from "@/services/slide.service";
import { Form, Formik } from "formik";
import { TextInput } from "@/components/Inputs";
import { Button } from "@/components/Buttons";
import { EXTERNAL_VIEWER_CONTROL_SCHEMA } from "@/utils/validationSchema/auth.schema";
import toast from "react-hot-toast";
import CreateExternalOpinioin from "../(components)/CreateExternalOpinioin";

const { VIEWER_URL } = env;

interface FormValues {
  access: string;
}

const Page = () => {
  const searchParams = useSearchParams();

  const { externalViewerData } = useSelector((state: RootState) => state.data);

  const reduxDispatch = useDispatch<AppDispatch>();

  const [isLoading, setIsLoading] = useState<boolean>();

  const slideId = searchParams.get("slideId");
  const email = searchParams.get("email");

  const initialValues: FormValues = {
    access: "",
  };

  const onVerfy = async (values: { access: string }) => {
    if (!slideId || !email) {
      toast.error("slideId or email not provided");
      return;
    }

    setIsLoading(true);

    slideService
      .verifySharedReport({
        slideId: slideId,
        email: email,
        code: values.access,
      })
      .then((res) => {
        const newData = {
          ...(res.data as object),
          accessEmail: email,
          accessCode: values.access,
        };

        reduxDispatch(setExternalViewerData(newData));
        toast.success("Access Granted");
      })
      .catch((err) => {
        console.log("error", err);
        toast.error(err?.message || "Could not verify");
      })
      .finally(() => {
        setIsLoading(false);
      });
  };

  const isAllowed = useMemo(() => {
    return !!externalViewerData?.reportId;
  }, [externalViewerData?.reportId]);

  return (
    <React.Fragment>
      {!isAllowed && (
        <div className="fixed inset-0 z-20 flex items-center justify-center bg-transparent backdrop-blur-lg">
          <div className="flex h-[400px] w-[85vw] flex-col rounded-lg bg-white sm:w-[500px]">
            <div className="mb-3 px-3 pb-3 pt-8 text-center shadow-sm sm:px-8">
              <span className="text-xl font-semibold text-grey">
                Verify Access
              </span>
            </div>
            <div className="relative flex flex-1 flex-col overflow-auto px-3 pb-4 pt-0 sm:px-8">
              <p className="text-center text-sm font-medium text-greySecondary">
                Please Provide the ACCESS CODE shared with you to view
              </p>
              <Formik
                initialValues={initialValues}
                validationSchema={EXTERNAL_VIEWER_CONTROL_SCHEMA}
                onSubmit={onVerfy}
              >
                {() => (
                  <Form className="mt-4 space-y-2" id="managePathologistForm">
                    <TextInput
                      name="access"
                      type="text"
                      label="Access Code"
                      disabled={isLoading}
                    />
                  </Form>
                )}
              </Formik>
            </div>
            <div className="flex w-full justify-end border-t-2 border-greyStroke px-3 py-6 sm:px-8">
              <Button
                variant="primary"
                type="submit"
                form="managePathologistForm"
                loading={isLoading}
              >
                Submit
              </Button>
            </div>
          </div>
        </div>
      )}
      <div className="flex h-full flex-1 flex-col gap-4 px-8 py-6">
        {isAllowed ? (
          <iframe
            src={`${VIEWER_URL}?slideId=${slideId}`}
            style={{ width: "100%", height: "100%" }}
            sandbox="allow-scripts allow-same-origin"
            allow="cross-origin-isolated"
            // onLoad={() =>
            //   console.log(`Iframe loaded: ${VIEWER_URL}?slideId=${slideId}`)
            // }
          />
        ) : (
          <div className="flex min-h-full w-full items-center justify-center rounded-[8px] bg-blackMain">
            <p className="px-4 text-center font-medium text-whiteShade">
              Loading viewer...
            </p>
          </div>
        )}
      </div>
      <CreateExternalOpinioin />
    </React.Fragment>
  );
};

export default Page;
