"use client";

import PageSkeleton from "@/components/Loading/PageSkeleton";
import ExternalNavbar from "@/components/Navbar/ExternalNavbar";
import { SidebarInset, SidebarProvider } from "@/components/ui/sidebar";
import { useState } from "react";

export default function Layout({ children }: { children: React.ReactNode }) {
  const [layoutLoading, setLayoutLoading] = useState<boolean>(true);

  setTimeout(() => {
    setLayoutLoading(false);
  }, 2000);

  return (
    <SidebarProvider defaultOpen={true} className="h-screen max-w-[2560px]">
      <SidebarInset className="overflow-hidden bg-greyLineLight">
        {layoutLoading ? (
          <PageSkeleton />
        ) : (
          <>
            <ExternalNavbar />
            <div className="flex-1 overflow-auto">{children}</div>
          </>
        )}
      </SidebarInset>
    </SidebarProvider>
  );
}
