"use client";

import Image from "next/image";
import React from "react";
import background from "@/assets/img/admin-bg-light.webp";
import logo from "@/assets/svg/xo-bridge-v3.svg";
import Link from "next/link";
import { useRouter } from "next/navigation";

const Layout = ({ children }: { children: React.ReactNode }) => {
  const router = useRouter();
  return (
    <div className="min-h-screen w-full">
      <Image
        onClick={() => router.push("/")}
        className="fixed top-0 -z-50"
        alt="background"
        src={background}
        priority
      />
      <div className="z-10 h-full min-h-screen bg-[#00000030] px-[10px] py-[10px] sm:px-[50px] sm:py-[50px]">
        <div className="mb-5 flex justify-center">
          <Link href="/">
            <Image className="w-40" src={logo} alt="Xolani Bridge Logo" />
          </Link>
        </div>

        {children}
      </div>
    </div>
  );
};

export default Layout;
