"use client";

import { Form, Formik } from "formik";
import Image from "next/image";
import React, { useState } from "react";
import cancelIcon from "@/assets/icons/cancel-primary.svg";
import Link from "next/link";
import { TextInput } from "@/components/Inputs";
import { Button } from "@/components/Buttons";
import { FORGOT_SCHEMA } from "@/utils/validationSchema/auth.schema";
import { useRouter } from "next/navigation";
import authService from "@/services/auth.service";
import toast from "react-hot-toast";
import { setAuthEmail } from "@/utils/sessions/session.utils";

interface FormValues {
  email: string;
}

const initialValues: FormValues = {
  email: "",
};

const Page = () => {
  const [isLoading, setIsLoading] = useState<boolean>(false);
  const router = useRouter();

  const onSubmit = (values: FormValues) => {
    setIsLoading(true);

    authService
      .forgotPassword(values.email)
      .then(() => {
        setAuthEmail(values.email);
        toast.success("Reset instructions sent");
        router.push("/auth/verify-otp");
      })
      .catch((error) => {
        toast.error(error?.message || error?.errors);
      })
      .finally(() => setIsLoading(false));
  };

  return (
    <div className="relative mx-auto w-[85vw] rounded-br-[60px] rounded-tl-[60px] bg-white sm:w-[560px]">
      <div className="pb-1 pt-10">
        <div className="px-4 py-4 text-center">
          <p className="m-0 text-[28px] font-medium text-blackMain sm:text-[32px]">
            Forgot Password
          </p>
          <p className="mb-0 text-[14px] font-normal text-grey">
            Enter your email to reset password{" "}
          </p>
        </div>
        <div className="mb-10 px-4 pb-16 pt-6 sm:px-12">
          <Formik
            initialValues={initialValues}
            validationSchema={FORGOT_SCHEMA}
            onSubmit={onSubmit}
          >
            {() => (
              <Form>
                <TextInput
                  name="email"
                  type="email"
                  label="Email Address"
                  disabled={isLoading}
                />

                <div className="mt-14 flex justify-end">
                  <Button type="submit" variant="primary" loading={isLoading}>
                    Send Reset Instructions
                  </Button>
                </div>
              </Form>
            )}
          </Formik>
        </div>
        <Link
          href="/auth/login"
          className="absolute right-[25px] top-[25px] cursor-pointer"
        >
          <Image src={cancelIcon} alt="cancel" className="h-[25px] w-[25px]" />
        </Link>
      </div>
    </div>
  );
};

export default Page;
