"use client";

import { Button } from "@/components/Buttons";
import userService from "@/services/user.service";
import { useRouter, useSearchParams } from "next/navigation";
import React, { Suspense, useState } from "react";
import toast from "react-hot-toast";

const AcceptInvite = () => {
  const router = useRouter();
  const searchParams = useSearchParams();
  const [isLoading, setIsLoading] = useState<boolean>(false);

  const ref = searchParams.get("invitationRef");
  const email = searchParams.get("email");

  const onAccepInvite = async () => {
    if (!ref || !email) {
      toast.error("No Ref Found, Please request another Invitation");
      return;
    }

    setIsLoading(true);
    userService
      .acceptPathologistInvite({
        invitationRef: ref,
        email: email,
      })
      .then((res) => {
        router.push("/auth/login");

        toast.success(res.message);
      })
      .catch((error) => {
        console.log(error);
        toast.error(error?.message || error?.errors);
      })
      .finally(() => {
        setIsLoading(false);
      });
  };

  return (
    <div className="relative mx-auto mt-20 w-[85vw] overflow-hidden rounded-xl bg-white sm:w-[560px]">
      <div className="py-8">
        <div className="px-4 py-4 text-center sm:px-5">
          <p className="m-0 text-[24px] font-medium text-blackMain">
            Accept Invite
          </p>
          <p className="mb-0 text-[16px] font-normal text-grey">
            Please click on the button to accept the invite.
          </p>
        </div>
        <div className="px-4 pb-10 pt-6 sm:px-12">
          <Button
            loading={isLoading}
            variant="primary"
            className="mx-auto"
            onClick={onAccepInvite}
          >
            Accept Invite
          </Button>
        </div>
      </div>
    </div>
  );
};

const Page = () => (
  <Suspense fallback={<p>Loading...</p>}>
    <AcceptInvite />
  </Suspense>
);

export default Page;
