import { NextRequest, NextResponse } from "next/server";
import axios from "axios";
import env from "../../../../env"; // Make sure this path is correct!

const { CAMICROSCOPE_BASE_URL } = env;

const finalUploadExternalUrl = `${CAMICROSCOPE_BASE_URL}/data/Slide/post`;

export async function POST(req: NextRequest) {
  try {
    const body = await req.json();

    const response = await axios.post(finalUploadExternalUrl, body, {
      headers: { "Content-Type": "application/json" },
    });

    return NextResponse.json(response.data, { status: 200 });
  } catch (error: any) {
    console.error("Proxy error:", error.message);
    return NextResponse.json({ error: error.message }, { status: 500 });
  }
}
