import { NextRequest, NextResponse } from "next/server";
import axios from "axios";

export async function GET(req: NextRequest) {
  try {
    const { searchParams } = new URL(req.url);
    const imageUrl = searchParams.get("url");

    if (!imageUrl) {
      return NextResponse.json({ error: "Missing image URL" }, { status: 400 });
    }

    const response = await axios.get(imageUrl, {
      responseType: "arraybuffer",
    });

    const contentType = response.headers["content-type"];

    return new NextResponse(response.data, {
      status: 200,
      headers: {
        "Content-Type": contentType,
        "Content-Length": response.headers["content-length"] || "",
        "Cache-Control": "no-cache",
      },
    });
  } catch (error: any) {
    console.error("Image proxy error:", error.message);
    return NextResponse.json({ error: error.message }, { status: 500 });
  }
}
