import { NextRequest, NextResponse } from 'next/server';
import jwt from 'jsonwebtoken';

export async function POST(req: NextRequest) {
  const { room, userId, username, email,avatar } = await req.json();

  const iss = process.env.JITSI_JWT_APP_ID
  const aud = process.env.JITSI_JWT_AUDIENCE
  const secret = process.env.JITSI_JWT_SECRET
  const now = Math.floor(Date.now() / 1000);
  const expiry = parseInt(process.env.JITSI_JWT_EXPIRY || '7200', 10); // default 2 hours
  const exp = now + expiry;

  const payload = {
    room,
    sub: 'meet.jitsi',
    aud,
    iss,
    exp,
    nbf: now,
    context: {
      user: {
        id: userId,
        name: username,
        email,
        avatar
      },
    },
  };


  const token = jwt.sign(payload, secret!, { algorithm: 'HS256' });
  return NextResponse.json({ token });
}