var _excluded = ["ref", "parse", "format", "value", "defaultValue", "controlled", "onChange", "onKeyDown"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

import { useCallback, useRef } from 'react';
import { onChange as onInputChange, onKeyDown as onInputKeyDown } from '../inputControl.js';
export default function useInput(_ref) {
  var ref = _ref.ref,
      parse = _ref.parse,
      format = _ref.format,
      value = _ref.value,
      defaultValue = _ref.defaultValue,
      _ref$controlled = _ref.controlled,
      controlled = _ref$controlled === void 0 ? true : _ref$controlled,
      onChange = _ref.onChange,
      onKeyDown = _ref.onKeyDown,
      rest = _objectWithoutProperties(_ref, _excluded);

  // It doesn't seem to be required to alert a developer about controlled/uncontrolled misuse:
  // if `controlled` is `true` then `defaultValue` is simply ignored.
  //
  // if (defaultValue && controlled) {
  // 	console.error('[input-format] You\'ve passed both `defaultValue` and `controlled: true` properties which is an invalid use case')
  // }
  var internalRef = useRef();
  var setRef = useCallback(function (instance) {
    internalRef.current = instance;

    if (ref) {
      if (typeof ref === 'function') {
        ref(instance);
      } else {
        ref.current = instance;
      }
    }
  }, [ref]);

  var _onChange = useCallback(function (event) {
    return onInputChange(event, internalRef.current, parse, format, onChange);
  }, [internalRef, parse, format, onChange]);

  var _onKeyDown = useCallback(function (event) {
    if (onKeyDown) {
      onKeyDown(event);
    } // If `onKeyDown()` handler above has called `event.preventDefault()`
    // then ignore this `keydown` event.


    if (event.defaultPrevented) {
      return;
    }

    return onInputKeyDown(event, internalRef.current, parse, format, onChange);
  }, [internalRef, parse, format, onChange, onKeyDown]);

  var commonProps = _objectSpread(_objectSpread({}, rest), {}, {
    ref: setRef,
    onChange: _onChange,
    onKeyDown: _onKeyDown
  });

  if (controlled) {
    return _objectSpread(_objectSpread({}, commonProps), {}, {
      value: format(isEmptyValue(value) ? '' : value).text
    });
  }

  return _objectSpread(_objectSpread({}, commonProps), {}, {
    defaultValue: format(isEmptyValue(defaultValue) ? '' : defaultValue).text
  });
}

function isEmptyValue(value) {
  return value === undefined || value === null;
}
//# sourceMappingURL=useInput.js.map