"use strict";

var _chai = require("chai");

var _sinon = require("sinon");

var _dom = require("./dom.js");

describe("DOM", function () {
  it("should get caret position", function () {
    (0, _chai.expect)((0, _dom.getCaretPosition)({
      selectionStart: 1
    })).to.equal(1);
  });
  it("should set caret position", function () {
    var setSelectionRange = (0, _sinon.spy)();
    (0, _dom.setCaretPosition)({
      setSelectionRange: setSelectionRange
    }, 1);
    (0, _chai.expect)(setSelectionRange.callCount).to.equal(1);
    (0, _chai.expect)(setSelectionRange.getCall(0).args).to.deep.equal([1, 1]);
    (0, _dom.setCaretPosition)({
      setSelectionRange: setSelectionRange
    });
    (0, _chai.expect)(setSelectionRange.callCount).to.equal(1);
  });
  it("should get selection", function () {
    (0, _chai.expect)((0, _dom.getSelection)({})).to.be.undefined;
    (0, _chai.expect)((0, _dom.getSelection)({
      selectionStart: 0,
      selectionEnd: 1
    })).to.deep.equal({
      start: 0,
      end: 1
    });
  });
  it("should get keydown operation", function () {
    (0, _chai.expect)((0, _dom.getOperation)({
      keyCode: 8
    })).to.equal('Backspace');
    (0, _chai.expect)((0, _dom.getOperation)({
      keyCode: 46
    })).to.equal('Delete');
    (0, _chai.expect)((0, _dom.getOperation)({
      keyCode: 1
    })).to.be.undefined;
  });
});
//# sourceMappingURL=dom.test.js.map