declare module 'country-region-data' {
	export type CountryName = "Afghanistan" | "Åland Islands" | "Albania" | "Algeria" | "American Samoa" | "Andorra" | "Angola" | "Anguilla" | "Antarctica" | "Antigua and Barbuda" | "Argentina" | "Armenia" | "Aruba" | "Australia" | "Austria" | "Azerbaijan" | "Bahamas" | "Bahrain" | "Bangladesh" | "Barbados" | "Belarus" | "Belgium" | "Belize" | "Benin" | "Bermuda" | "Bhutan" | "Bolivia" | "Bonaire, Sint Eustatius and Saba" | "Bosnia and Herzegovina" | "Botswana" | "Bouvet Island" | "Brazil" | "British Indian Ocean Territory" | "Brunei Darussalam" | "Bulgaria" | "Burkina Faso" | "Burundi" | "Cambodia" | "Cameroon" | "Canada" | "Cape Verde" | "Cayman Islands" | "Central African Republic" | "Chad" | "Chile" | "China" | "Christmas Island" | "Cocos (Keeling) Islands" | "Colombia" | "Comoros" | "Congo, Republic of the (Brazzaville)" | "Congo, the Democratic Republic of the (Kinshasa)" | "Cook Islands" | "Costa Rica" | "Côte d'Ivoire, Republic of" | "Croatia" | "Cuba" | "Curaçao" | "Cyprus" | "Czech Republic" | "Denmark" | "Djibouti" | "Dominica" | "Dominican Republic" | "Ecuador" | "Egypt" | "El Salvador" | "Equatorial Guinea" | "Eritrea" | "Estonia" | "Ethiopia" | "Falkland Islands (Islas Malvinas)" | "Faroe Islands" | "Fiji" | "Finland" | "France" | "French Guiana" | "French Polynesia" | "French Southern and Antarctic Lands" | "Gabon" | "Gambia, The" | "Georgia" | "Germany" | "Ghana" | "Gibraltar" | "Greece" | "Greenland" | "Grenada" | "Guadeloupe" | "Guam" | "Guatemala" | "Guernsey" | "Guinea" | "Guinea-Bissau" | "Guyana" | "Haiti" | "Heard Island and McDonald Islands" | "Holy See (Vatican City)" | "Honduras" | "Hong Kong" | "Hungary" | "Iceland" | "India" | "Indonesia" | "Iran, Islamic Republic of" | "Iraq" | "Ireland" | "Isle of Man" | "Israel" | "Italy" | "Jamaica" | "Japan" | "Jersey" | "Jordan" | "Kazakhstan" | "Kenya" | "Kiribati" | "Korea, Democratic People's Republic of" | "Korea, Republic of" | "Kosovo" | "Kuwait" | "Kyrgyzstan" | "Laos" | "Latvia" | "Lebanon" | "Lesotho" | "Liberia" | "Libya" | "Liechtenstein" | "Lithuania" | "Luxembourg" | "Macao" | "Macedonia, Republic of" | "Madagascar" | "Malawi" | "Malaysia" | "Maldives" | "Mali" | "Malta" | "Marshall Islands" | "Martinique" | "Mauritania" | "Mauritius" | "Mayotte" | "Mexico" | "Micronesia, Federated States of" | "Moldova" | "Monaco" | "Mongolia" | "Montenegro" | "Montserrat" | "Morocco" | "Mozambique" | "Myanmar" | "Namibia" | "Nauru" | "Nepal" | "Netherlands" | "New Caledonia" | "New Zealand" | "Nicaragua" | "Niger" | "Nigeria" | "Niue" | "Norfolk Island" | "Northern Mariana Islands" | "Norway" | "Oman" | "Pakistan" | "Palau" | "Palestine" | "Panama" | "Papua New Guinea" | "Paraguay" | "Peru" | "Philippines" | "Pitcairn" | "Poland" | "Portugal" | "Puerto Rico" | "Qatar" | "Réunion" | "Romania" | "Russian Federation" | "Rwanda" | "Saint Barthélemy" | "Saint Helena, Ascension and Tristan da Cunha" | "Saint Kitts and Nevis" | "Saint Lucia" | "Saint Martin" | "Saint Pierre and Miquelon" | "Saint Vincent and the Grenadines" | "Samoa" | "San Marino" | "Sao Tome and Principe" | "Saudi Arabia" | "Senegal" | "Serbia" | "Seychelles" | "Sierra Leone" | "Singapore" | "Sint Maarten (Dutch part)" | "Slovakia" | "Slovenia" | "Solomon Islands" | "Somalia" | "South Africa" | "South Georgia and South Sandwich Islands" | "South Sudan" | "Spain" | "Sri Lanka" | "Sudan" | "Suriname" | "Eswatini" | "Sweden" | "Switzerland" | "Syrian Arab Republic" | "Taiwan" | "Tajikistan" | "Tanzania, United Republic of" | "Thailand" | "Timor-Leste" | "Togo" | "Tokelau" | "Tonga" | "Trinidad and Tobago" | "Tunisia" | "Turkey" | "Turkmenistan" | "Turks and Caicos Islands" | "Tuvalu" | "Uganda" | "Ukraine" | "United Arab Emirates" | "United Kingdom" | "United States" | "United States Minor Outlying Islands" | "Uruguay" | "Uzbekistan" | "Vanuatu" | "Venezuela, Bolivarian Republic of" | "Vietnam" | "Virgin Islands, British" | "Virgin Islands, U.S." | "Wallis and Futuna" | "Western Sahara" | "Yemen" | "Zambia" | "Zimbabwe";
	export type CountrySlug = "AF" | "AX" | "AL" | "DZ" | "AS" | "AD" | "AO" | "AI" | "AQ" | "AG" | "AR" | "AM" | "AW" | "AU" | "AT" | "AZ" | "BS" | "BH" | "BD" | "BB" | "BY" | "BE" | "BZ" | "BJ" | "BM" | "BT" | "BO" | "BQ" | "BA" | "BW" | "BV" | "BR" | "IO" | "BN" | "BG" | "BF" | "BI" | "KH" | "CM" | "CA" | "CV" | "KY" | "CF" | "TD" | "CL" | "CN" | "CX" | "CC" | "CO" | "KM" | "CG" | "CD" | "CK" | "CR" | "CI" | "HR" | "CU" | "CW" | "CY" | "CZ" | "DK" | "DJ" | "DM" | "DO" | "EC" | "EG" | "SV" | "GQ" | "ER" | "EE" | "ET" | "FK" | "FO" | "FJ" | "FI" | "FR" | "GF" | "PF" | "TF" | "GA" | "GM" | "GE" | "DE" | "GH" | "GI" | "GR" | "GL" | "GD" | "GP" | "GU" | "GT" | "GG" | "GN" | "GW" | "GY" | "HT" | "HM" | "VA" | "HN" | "HK" | "HU" | "IS" | "IN" | "ID" | "IR" | "IQ" | "IE" | "IM" | "IL" | "IT" | "JM" | "JP" | "JE" | "JO" | "KZ" | "KE" | "KI" | "KP" | "KR" | "XK" | "KW" | "KG" | "LA" | "LV" | "LB" | "LS" | "LR" | "LY" | "LI" | "LT" | "LU" | "MO" | "MK" | "MG" | "MW" | "MY" | "MV" | "ML" | "MT" | "MH" | "MQ" | "MR" | "MU" | "YT" | "MX" | "FM" | "MD" | "MC" | "MN" | "ME" | "MS" | "MA" | "MZ" | "MM" | "NA" | "NR" | "NP" | "NL" | "NC" | "NZ" | "NI" | "NE" | "NG" | "NU" | "NF" | "MP" | "NO" | "OM" | "PK" | "PW" | "PS" | "PA" | "PG" | "PY" | "PE" | "PH" | "PN" | "PL" | "PT" | "PR" | "QA" | "RE" | "RO" | "RU" | "RW" | "BL" | "SH" | "KN" | "LC" | "MF" | "PM" | "VC" | "WS" | "SM" | "ST" | "SA" | "SN" | "RS" | "SC" | "SL" | "SG" | "SX" | "SK" | "SI" | "SB" | "SO" | "ZA" | "GS" | "SS" | "ES" | "LK" | "SD" | "SR" | "SZ" | "SE" | "CH" | "SY" | "TW" | "TJ" | "TZ" | "TH" | "TL" | "TG" | "TK" | "TO" | "TT" | "TN" | "TR" | "TM" | "TC" | "TV" | "UG" | "UA" | "AE" | "GB" | "US" | "UM" | "UY" | "UZ" | "VU" | "VE" | "VN" | "VG" | "VI" | "WF" | "EH" | "YE" | "ZM" | "ZW";
	export type RegionName = string;
	export type RegionSlug = string;

	export const countryNames: CountryName[];
	export const countryShortCodes: CountrySlug[];
	export const countryTuples: [CountryName, CountrySlug][];
	export type Region = [RegionName, RegionSlug];
	
	export type CountryData = [
		CountryName,
		CountrySlug,
		Region[]
	];
	
	export const allCountries: CountryData[];	
	export default allCountries;
	export const AF: CountryData;
	export const AX: CountryData;
	export const AL: CountryData;
	export const DZ: CountryData;
	export const AS: CountryData;
	export const AD: CountryData;
	export const AO: CountryData;
	export const AI: CountryData;
	export const AQ: CountryData;
	export const AG: CountryData;
	export const AR: CountryData;
	export const AM: CountryData;
	export const AW: CountryData;
	export const AU: CountryData;
	export const AT: CountryData;
	export const AZ: CountryData;
	export const BS: CountryData;
	export const BH: CountryData;
	export const BD: CountryData;
	export const BB: CountryData;
	export const BY: CountryData;
	export const BE: CountryData;
	export const BZ: CountryData;
	export const BJ: CountryData;
	export const BM: CountryData;
	export const BT: CountryData;
	export const BO: CountryData;
	export const BQ: CountryData;
	export const BA: CountryData;
	export const BW: CountryData;
	export const BV: CountryData;
	export const BR: CountryData;
	export const IO: CountryData;
	export const BN: CountryData;
	export const BG: CountryData;
	export const BF: CountryData;
	export const BI: CountryData;
	export const KH: CountryData;
	export const CM: CountryData;
	export const CA: CountryData;
	export const CV: CountryData;
	export const KY: CountryData;
	export const CF: CountryData;
	export const TD: CountryData;
	export const CL: CountryData;
	export const CN: CountryData;
	export const CX: CountryData;
	export const CC: CountryData;
	export const CO: CountryData;
	export const KM: CountryData;
	export const CG: CountryData;
	export const CD: CountryData;
	export const CK: CountryData;
	export const CR: CountryData;
	export const CI: CountryData;
	export const HR: CountryData;
	export const CU: CountryData;
	export const CW: CountryData;
	export const CY: CountryData;
	export const CZ: CountryData;
	export const DK: CountryData;
	export const DJ: CountryData;
	export const DM: CountryData;
	export const DO: CountryData;
	export const EC: CountryData;
	export const EG: CountryData;
	export const SV: CountryData;
	export const GQ: CountryData;
	export const ER: CountryData;
	export const EE: CountryData;
	export const ET: CountryData;
	export const FK: CountryData;
	export const FO: CountryData;
	export const FJ: CountryData;
	export const FI: CountryData;
	export const FR: CountryData;
	export const GF: CountryData;
	export const PF: CountryData;
	export const TF: CountryData;
	export const GA: CountryData;
	export const GM: CountryData;
	export const GE: CountryData;
	export const DE: CountryData;
	export const GH: CountryData;
	export const GI: CountryData;
	export const GR: CountryData;
	export const GL: CountryData;
	export const GD: CountryData;
	export const GP: CountryData;
	export const GU: CountryData;
	export const GT: CountryData;
	export const GG: CountryData;
	export const GN: CountryData;
	export const GW: CountryData;
	export const GY: CountryData;
	export const HT: CountryData;
	export const HM: CountryData;
	export const VA: CountryData;
	export const HN: CountryData;
	export const HK: CountryData;
	export const HU: CountryData;
	export const IS: CountryData;
	export const IN: CountryData;
	export const ID: CountryData;
	export const IR: CountryData;
	export const IQ: CountryData;
	export const IE: CountryData;
	export const IM: CountryData;
	export const IL: CountryData;
	export const IT: CountryData;
	export const JM: CountryData;
	export const JP: CountryData;
	export const JE: CountryData;
	export const JO: CountryData;
	export const KZ: CountryData;
	export const KE: CountryData;
	export const KI: CountryData;
	export const KP: CountryData;
	export const KR: CountryData;
	export const XK: CountryData;
	export const KW: CountryData;
	export const KG: CountryData;
	export const LA: CountryData;
	export const LV: CountryData;
	export const LB: CountryData;
	export const LS: CountryData;
	export const LR: CountryData;
	export const LY: CountryData;
	export const LI: CountryData;
	export const LT: CountryData;
	export const LU: CountryData;
	export const MO: CountryData;
	export const MK: CountryData;
	export const MG: CountryData;
	export const MW: CountryData;
	export const MY: CountryData;
	export const MV: CountryData;
	export const ML: CountryData;
	export const MT: CountryData;
	export const MH: CountryData;
	export const MQ: CountryData;
	export const MR: CountryData;
	export const MU: CountryData;
	export const YT: CountryData;
	export const MX: CountryData;
	export const FM: CountryData;
	export const MD: CountryData;
	export const MC: CountryData;
	export const MN: CountryData;
	export const ME: CountryData;
	export const MS: CountryData;
	export const MA: CountryData;
	export const MZ: CountryData;
	export const MM: CountryData;
	export const NA: CountryData;
	export const NR: CountryData;
	export const NP: CountryData;
	export const NL: CountryData;
	export const NC: CountryData;
	export const NZ: CountryData;
	export const NI: CountryData;
	export const NE: CountryData;
	export const NG: CountryData;
	export const NU: CountryData;
	export const NF: CountryData;
	export const MP: CountryData;
	export const NO: CountryData;
	export const OM: CountryData;
	export const PK: CountryData;
	export const PW: CountryData;
	export const PS: CountryData;
	export const PA: CountryData;
	export const PG: CountryData;
	export const PY: CountryData;
	export const PE: CountryData;
	export const PH: CountryData;
	export const PN: CountryData;
	export const PL: CountryData;
	export const PT: CountryData;
	export const PR: CountryData;
	export const QA: CountryData;
	export const RE: CountryData;
	export const RO: CountryData;
	export const RU: CountryData;
	export const RW: CountryData;
	export const BL: CountryData;
	export const SH: CountryData;
	export const KN: CountryData;
	export const LC: CountryData;
	export const MF: CountryData;
	export const PM: CountryData;
	export const VC: CountryData;
	export const WS: CountryData;
	export const SM: CountryData;
	export const ST: CountryData;
	export const SA: CountryData;
	export const SN: CountryData;
	export const RS: CountryData;
	export const SC: CountryData;
	export const SL: CountryData;
	export const SG: CountryData;
	export const SX: CountryData;
	export const SK: CountryData;
	export const SI: CountryData;
	export const SB: CountryData;
	export const SO: CountryData;
	export const ZA: CountryData;
	export const GS: CountryData;
	export const SS: CountryData;
	export const ES: CountryData;
	export const LK: CountryData;
	export const SD: CountryData;
	export const SR: CountryData;
	export const SZ: CountryData;
	export const SE: CountryData;
	export const CH: CountryData;
	export const SY: CountryData;
	export const TW: CountryData;
	export const TJ: CountryData;
	export const TZ: CountryData;
	export const TH: CountryData;
	export const TL: CountryData;
	export const TG: CountryData;
	export const TK: CountryData;
	export const TO: CountryData;
	export const TT: CountryData;
	export const TN: CountryData;
	export const TR: CountryData;
	export const TM: CountryData;
	export const TC: CountryData;
	export const TV: CountryData;
	export const UG: CountryData;
	export const UA: CountryData;
	export const AE: CountryData;
	export const GB: CountryData;
	export const US: CountryData;
	export const UM: CountryData;
	export const UY: CountryData;
	export const UZ: CountryData;
	export const VU: CountryData;
	export const VE: CountryData;
	export const VN: CountryData;
	export const VG: CountryData;
	export const VI: CountryData;
	export const WF: CountryData;
	export const EH: CountryData;
	export const YE: CountryData;
	export const ZM: CountryData;
	export const ZW: CountryData;
}
